/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.security;

import ghidra.framework.remote.GhidraPrincipal;
import ghidra.framework.remote.SSHSignatureCallback;
import ghidra.framework.remote.security.SSHKeyManager;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.net.ApplicationKeyManagerUtils;
import ghidra.net.SignedToken;
import ghidra.server.UserManager;
import ghidra.server.security.TokenGenerator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.DSAKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.util.Strings;

public class SSHAuthenticationModule {
    private static final long MAX_TOKEN_TIME = 10000L;
    private static final int TOKEN_SIZE = 64;
    private final boolean nameCallbackAllowed;

    public SSHAuthenticationModule(boolean nameCallbackAllowed) {
        this.nameCallbackAllowed = nameCallbackAllowed;
    }

    public Callback[] addAuthenticationCallbacks(Callback[] primaryAuthCallbacks) {
        boolean addNameCallback = this.nameCallbackAllowed;
        if (this.nameCallbackAllowed && primaryAuthCallbacks != null) {
            for (Callback cb : primaryAuthCallbacks) {
                if (!(cb instanceof NameCallback)) continue;
                addNameCallback = false;
                break;
            }
        }
        ArrayList<Callback> list = new ArrayList<Callback>();
        if (primaryAuthCallbacks != null) {
            list.addAll(Arrays.asList(primaryAuthCallbacks));
        }
        if (addNameCallback) {
            list.add(new NameCallback("User ID:"));
        }
        byte[] token = TokenGenerator.getNewToken(64);
        try {
            boolean usingSelfSignedCert = ApplicationKeyManagerFactory.usingGeneratedSelfSignedCertificate();
            SignedToken signedToken = ApplicationKeyManagerUtils.getSignedToken((Principal[])(usingSelfSignedCert ? null : ApplicationKeyManagerUtils.getTrustedIssuers()), (byte[])token);
            list.add((Callback)new SSHSignatureCallback(token, signedToken.signature));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate signed token", e);
        }
        return list.toArray(new Callback[list.size()]);
    }

    public boolean hasSignedSSHCallback(Callback[] callbacks) {
        if (callbacks != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof SSHSignatureCallback)) continue;
                SSHSignatureCallback sshCb = (SSHSignatureCallback)callbacks[i];
                return sshCb.isSigned();
            }
        }
        return false;
    }

    private static int sshBufferReadUInt32(ByteArrayInputStream in) throws IOException {
        byte[] tmp = in.readNBytes(4);
        if (tmp.length != 4) {
            throw new IOException("insufficient data");
        }
        int value = (tmp[0] & 0xFF) << 24;
        value |= (tmp[1] & 0xFF) << 16;
        value |= (tmp[2] & 0xFF) << 8;
        return value |= tmp[3] & 0xFF;
    }

    private static byte[] sshBufferReadBlock(ByteArrayInputStream in) throws IOException {
        int len = SSHAuthenticationModule.sshBufferReadUInt32(in);
        if (len <= 0 || len > in.available()) {
            throw new IOException("insufficient data");
        }
        return in.readNBytes(len);
    }

    public String authenticate(UserManager userMgr, Subject subject, Callback[] callbacks) throws LoginException {
        String username;
        block25: {
            GhidraPrincipal user = GhidraPrincipal.getGhidraPrincipal((Subject)subject);
            if (user == null) {
                throw new FailedLoginException("GhidraPrincipal required");
            }
            username = user.getName();
            NameCallback nameCb = null;
            SSHSignatureCallback sshCb = null;
            if (callbacks != null) {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        nameCb = (NameCallback)callbacks[i];
                    }
                    if (!(callbacks[i] instanceof SSHSignatureCallback)) continue;
                    sshCb = (SSHSignatureCallback)callbacks[i];
                }
            }
            if (this.nameCallbackAllowed && nameCb != null) {
                username = nameCb.getName();
            }
            if (username == null || username.length() == 0) {
                throw new FailedLoginException("User ID must be specified");
            }
            if (!userMgr.isValidUser(username)) {
                throw new FailedLoginException("Unknown user: " + username);
            }
            if (sshCb == null) {
                throw new FailedLoginException("SSH Signature callback not found for user: " + username);
            }
            File sshPublicKeyFile = userMgr.getSSHPubKeyFile(username);
            if (sshPublicKeyFile == null) {
                throw new FailedLoginException("SSH public key file not found for user: " + username);
            }
            byte[] sigBytes = sshCb.getSignature();
            if (sigBytes == null) {
                throw new FailedLoginException("SSH Signature missing");
            }
            byte[] token = sshCb.getToken();
            if (!TokenGenerator.isRecentToken(token, 10000L)) {
                throw new FailedLoginException("Stale SSH Signature callback");
            }
            boolean isValid = false;
            try {
                boolean usingSelfSignedCert = ApplicationKeyManagerFactory.usingGeneratedSelfSignedCertificate();
                isValid = ApplicationKeyManagerUtils.isMySignature((Principal[])(usingSelfSignedCert ? null : ApplicationKeyManagerUtils.getTrustedIssuers()), (byte[])token, (byte[])sshCb.getServerSignature());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to verify signed token", e);
            }
            if (!isValid) {
                throw new FailedLoginException("Invalid SSH Signature callback");
            }
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(sigBytes);
                String keyAlgorithm = Strings.fromByteArray((byte[])SSHAuthenticationModule.sshBufferReadBlock(in));
                byte[] sig = SSHAuthenticationModule.sshBufferReadBlock(in);
                if (in.available() != 0) {
                    throw new FailedLoginException("SSH Signature contained extra bytes");
                }
                CipherParameters cipherParams = SSHKeyManager.getSSHPublicKey((File)sshPublicKeyFile);
                if (cipherParams instanceof RSAKeyParameters) {
                    if (!"ssh-rsa".equals(keyAlgorithm)) {
                        throw new FailedLoginException("Invalid SSH RSA Signature");
                    }
                    RSADigestSigner signer = new RSADigestSigner((Digest)new SHA1Digest());
                    signer.init(false, cipherParams);
                    signer.update(token, 0, token.length);
                    if (!signer.verifySignature(sig)) {
                        throw new FailedLoginException("Incorrect signature");
                    }
                    break block25;
                }
                if (cipherParams instanceof DSAKeyParameters) {
                    if (!"ssh-dss".equals(keyAlgorithm)) {
                        throw new FailedLoginException("Invalid SSH DSA Signature");
                    }
                    DSADigestSigner signer = new DSADigestSigner((DSA)new DSASigner(), (Digest)new SHA1Digest());
                    signer.init(false, cipherParams);
                    signer.update(token, 0, token.length);
                    if (!signer.verifySignature(sig)) {
                        throw new FailedLoginException("Incorrect signature");
                    }
                    break block25;
                }
                throw new FailedLoginException("Unsupported public key");
            }
            catch (LoginException e) {
                throw e;
            }
            catch (Throwable t) {
                String msg = t.getMessage();
                if (msg == null) {
                    msg = t.toString();
                }
                throw new FailedLoginException(msg);
            }
        }
        return username;
    }

    public boolean allowsNameCallback() {
        return this.nameCallbackAllowed;
    }
}

