/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.RedBlackNode;
import generic.stl.RedBlackTree;
import generic.stl.SetIterator;

public class ReverseSetIterator<T>
extends SetIterator<T> {
    ReverseSetIterator(RedBlackTree<T, T> tree, RedBlackNode<T, T> node) {
        super(tree, node);
    }

    @Override
    public IteratorSTL<T> copy() {
        return new ReverseSetIterator<T>(this.tree, this.node);
    }

    @Override
    public IteratorSTL<T> increment() {
        if (this.node == null) {
            throw new IndexOutOfBoundsException();
        }
        this.node = this.node.getPredecessor();
        return this;
    }

    @Override
    public IteratorSTL<T> decrement() {
        if (this.node == null && this.tree.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        this.node = this.node == null ? this.tree.getFirst() : this.node.getSuccessor();
        return this;
    }

    public void delete() {
        if (this.node == null) {
            throw new IndexOutOfBoundsException();
        }
        RedBlackNode nextNode = this.node.getPredecessor();
        this.tree.deleteEntry(this.node);
        this.node = nextNode;
    }

    @Override
    public boolean isBegin() {
        return this.node == this.tree.getLast();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ReverseSetIterator other = (ReverseSetIterator)obj;
        return this.tree == other.tree && this.node == other.node;
    }

    @Override
    public int hashCode() {
        return this.tree.hashCode();
    }
}

