/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;

public final class FBPK_Constants {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final String FBPK = "FBPK";
    public static final String FBPT = "FBPT";
    public static final String UFPK = "UFPK";
    public static final String UFSM = "UFSM";
    public static final String UFSP = "UFSP";
    public static final int FBPK_MAGIC = 1263551046;
    public static final int FBPT_MAGIC = 1414545990;
    public static final int UFPK_MAGIC = 1263552085;
    public static final int UFSM_MAGIC = 1297303125;
    public static final int UFSP_MAGIC = 1347634773;
    public static final int NAME_MAX_LENGTH = 36;
    public static final int PARTITION_TYPE_DIRECTORY = 0;
    public static final int PARTITION_TYPE_FILE = 1;
    public static final String PARTITION_TABLE = "partition table";
    public static final String V1_LAST_PARTITION_ENTRY = "last_parti";
    public static final int V1_VERSION_MAX_LENGTH = 68;
    public static final int V1_PADDING_LENGTH = 2;
    public static final String V2_PARTITION = "partition:";
    public static final String V2_UFS = "ufs";
    public static final Object V2_UFSFWUPDATE = "ufsfwupdate";
    public static final int V2_PARTITION_NAME_MAX_LENGTH = 76;
    public static final int V2_STRING1_MAX_LENGTH = 16;
    public static final int V2_STRING2_MAX_LENGTH = 68;
    public static final int V2_FORMAT_MAX_LENGTH = 14;
    public static final int V2_GUID_MAX_LENGTH = 44;
    public static final int V2_UFPK_STRING1_MAX_LENGTH = 76;

    public static boolean isFBPK(Program program) {
        try {
            Memory memory = program.getMemory();
            int magic = memory.getInt(program.getMinAddress());
            return magic == 1263551046;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

