/*
 * Decompiled with CFR 0.152.
 */
package help.validator.model;

import help.HelpBuildUtils;
import help.validator.location.HelpModuleLocation;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;

public class HREF
implements Comparable<HREF> {
    private HelpModuleLocation help;
    private final Path sourceFile;
    private Path refFile;
    private String anchorName;
    private final int lineNumber;
    private final String href;
    private final boolean isRemote;
    private boolean isLocalAnchor;
    private Path relativePath;

    public HREF(HelpModuleLocation help, Path sourceFile, String href, int lineNum) throws URISyntaxException {
        URI resolved;
        this.help = help;
        this.sourceFile = sourceFile;
        this.href = href;
        this.lineNumber = lineNum;
        if (href.startsWith("help/topics/")) {
            resolved = new URI(href);
        } else {
            URI URI2 = sourceFile.toUri();
            resolved = URI2.resolve(href);
        }
        this.isRemote = HelpBuildUtils.isRemote(resolved);
        if (!this.isRemote) {
            if (resolved.getFragment() == null) {
                this.refFile = HelpBuildUtils.locateReference(sourceFile, href);
                this.anchorName = null;
            } else if (resolved.getPath() == null) {
                this.refFile = sourceFile;
                this.anchorName = resolved.getFragment();
                this.isLocalAnchor = true;
            } else {
                this.refFile = HelpBuildUtils.locateReference(sourceFile, href);
                this.anchorName = resolved.getFragment();
            }
        }
        this.relativePath = HelpBuildUtils.relativizeWithHelpTopics(this.refFile);
    }

    public boolean isURL() {
        return this.isRemote;
    }

    public boolean isLocalAnchor() {
        return this.isLocalAnchor;
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public String getRefString() {
        return this.href;
    }

    public Path getReferenceFileHelpPath() {
        return this.relativePath;
    }

    public String getHelpPath() {
        Path referenceFileHelpPath = this.getReferenceFileHelpPath();
        if (referenceFileHelpPath == null) {
            return null;
        }
        if (this.anchorName == null) {
            return referenceFileHelpPath.toString();
        }
        return referenceFileHelpPath.toString() + "#" + this.anchorName;
    }

    @Override
    public int compareTo(HREF other) {
        if (this.equals(other)) {
            return 0;
        }
        HelpModuleLocation otherHelp = other.help;
        Path otherHelpLoc = otherHelp.getHelpLocation();
        Path myHelpLoc = this.help.getHelpLocation();
        if (!myHelpLoc.equals(otherHelpLoc)) {
            return myHelpLoc.compareTo(otherHelpLoc);
        }
        Path otherSourceFile = other.getSourceFile();
        if (!this.sourceFile.equals(otherSourceFile)) {
            return this.sourceFile.compareTo(otherSourceFile);
        }
        if (this.lineNumber != other.lineNumber) {
            return this.lineNumber - other.lineNumber;
        }
        String helpPath = this.getHelpPath();
        String otherHelpPath = other.getHelpPath();
        if (helpPath != null && otherHelpPath != null) {
            int result = helpPath.compareTo(otherHelpPath);
            if (result != 0) {
                return result;
            }
        } else {
            if (helpPath == null && otherHelpPath != null) {
                return -1;
            }
            if (helpPath != null && otherHelpPath == null) {
                return 1;
            }
        }
        int identityHashCode = System.identityHashCode(this);
        int otherIdentityHashCode = System.identityHashCode(other);
        return identityHashCode - otherIdentityHashCode;
    }

    public String toString() {
        String source = null;
        Path sourcePath = HelpBuildUtils.relativizeWithHelpTopics(this.sourceFile);
        if (sourcePath == null) {
            Path repoRoot = this.help.getModuleRepoRoot();
            Path name = repoRoot.getFileName();
            sourcePath = HelpBuildUtils.relativize(name, this.sourceFile);
        }
        source = sourcePath.toString();
        return "<a href=\"" + this.href + "\">\n\t\t\tFrom: " + source + " (line:" + this.lineNumber + "),\n\t\t\tResolved to: " + String.valueOf(this.refFile);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

