/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.ContextSpecificAction;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatable.ProjectTreeContext;
import ghidra.framework.main.datatree.DataTree;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import javax.swing.tree.TreePath;

public class ProjectDataExpandAction<T extends ProjectTreeContext>
extends ContextSpecificAction<T> {
    public ProjectDataExpandAction(String owner, String group, Class<T> contextClass) {
        super("Expand All", owner, contextClass);
        this.setPopupMenuData(new MenuData(new String[]{"Expand All"}, group));
        this.markHelpUnnecessary();
    }

    protected void actionPerformed(T context) {
        DataTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        this.expand(tree, paths[0]);
    }

    protected boolean isEnabledForContext(T context) {
        if (!context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        TreePath[] paths = context.getSelectionPaths();
        GTreeNode node = (GTreeNode)paths[0].getLastPathComponent();
        if (node instanceof DomainFolderNode) {
            return true;
        }
        if (node instanceof DomainFileNode) {
            DomainFileNode fileNode = (DomainFileNode)node;
            return fileNode.isFolderLink() && !fileNode.isLeaf();
        }
        return false;
    }

    private void expand(DataTree tree, TreePath path) {
        tree.expandTree((GTreeNode)path.getLastPathComponent());
    }
}

