/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.sys;

import ghidra.pcode.emu.sys.EmuFileContents;
import ghidra.pcode.emu.sys.EmuIOException;

public class BytesEmuFileContents
implements EmuFileContents<byte[]> {
    protected static final int INIT_CONTENT_SIZE = 1024;
    protected byte[] content = new byte[1024];

    @Override
    public synchronized long read(long offset, byte[] buf, long fileSize) {
        if (offset > Integer.MAX_VALUE) {
            throw new EmuIOException("Offset is past end of file");
        }
        long len = Math.min((long)buf.length, fileSize - offset);
        if (len < 0L) {
            throw new EmuIOException("Offset is past end of file");
        }
        System.arraycopy(this.content, (int)offset, buf, 0, (int)len);
        return len;
    }

    @Override
    public synchronized long write(long offset, byte[] buf, long curSize) {
        long newSize = offset + (long)buf.length;
        if (newSize > Integer.MAX_VALUE || newSize < 0L) {
            throw new EmuIOException("File size cannot exceed 2147483647 bytes");
        }
        if (newSize > (long)this.content.length) {
            byte[] grown = new byte[this.content.length * 2];
            System.arraycopy(this.content, 0, grown, 0, (int)curSize);
            this.content = grown;
        }
        System.arraycopy(buf, 0, this.content, (int)offset, buf.length);
        return buf.length;
    }

    @Override
    public synchronized void truncate() {
        if (this.content.length > 1024) {
            this.content = new byte[1024];
        }
    }
}

