/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import java.util.ArrayList;
import java.util.List;

public class EnvironmentBlockMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4413;
    private int flags;
    private boolean rev;
    private List<String> stringList = new ArrayList<String>();

    public EnvironmentBlockMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        String string;
        this.flags = reader.parseUnsignedByteVal();
        while (reader.hasMore() && !(string = reader.parseString(pdb, StringParseType.StringUtf8Nt)).isEmpty()) {
            this.stringList.add(string);
        }
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 4413;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isRev() {
        return this.rev;
    }

    public List<String> getStringList() {
        return this.stringList;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(":\n");
        builder.append(String.format("Compiled for edit and continue: %s\n", this.rev ? "yes" : "no"));
        if ((this.stringList.size() & 1) == 1) {
            return;
        }
        builder.append("Command block: \n");
        for (int i = 0; i < this.stringList.size(); i += 2) {
            builder.append(String.format("   %s = '%s'\n", this.stringList.get(i), this.stringList.get(i + 1)));
        }
    }

    @Override
    protected String getSymbolTypeName() {
        return "ENVBLOCK";
    }
}

