/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import java.util.Map;
import java.util.Set;

public class TokenFieldSolver
extends AbstractExpressionSolver<TokenField> {
    public TokenFieldSolver() {
        super(TokenField.class);
    }

    @Override
    public AssemblyResolution solve(AbstractAssemblyResolutionFactory<?, ?> factory, TokenField tf, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) {
        assert (tf.minValue() == 0L);
        if (!goal.isInRange(tf.maxValue(), tf.hasSignbit())) {
            return ((AbstractAssemblyResolutionFactory.AssemblyResolvedErrorBuilder)factory.newErrorBuilder().error("Value " + String.valueOf(goal) + " is not valid for " + String.valueOf(tf)).description(description)).build();
        }
        AssemblyPatternBlock block = AssemblyPatternBlock.fromTokenField(tf, goal);
        return factory.instrOnly(block, description);
    }

    @Override
    public MaskedLong getValue(TokenField tf, Map<String, Long> vals, AssemblyResolvedPatterns cur) {
        if (cur == null) {
            return null;
        }
        return this.valueForResolution(tf, vals, cur);
    }

    @Override
    public int getInstructionLength(TokenField tf) {
        return tf.getByteEnd() + 1;
    }

    @Override
    public MaskedLong valueForResolution(TokenField tf, Map<String, Long> vals, AssemblyResolvedPatterns rc) {
        int size = tf.getByteEnd() - tf.getByteStart() + 1;
        MaskedLong res = rc.readInstruction(tf.getByteStart(), size);
        if (!tf.isBigEndian()) {
            res = res.byteSwap(size);
        }
        res = res.shiftRight(tf.getShift());
        res = tf.hasSignbit() ? res.signExtend(tf.getBitEnd() - tf.getBitStart() + 1) : res.zeroExtend(tf.getBitEnd() - tf.getBitStart() + 1);
        return res;
    }
}

