/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.util.bin.format.golang;

import java.util.List;

import ghidra.program.model.data.CategoryPath;

/**
 * Misc constant values for golang
 */
public class GoConstants {
	public static final String GOLANG_CSPEC_NAME = "golang";

	/**
	 * Category path to place Go types in
	 */
	public static final CategoryPath GOLANG_CATEGORYPATH = new CategoryPath("/golang");
	public static final CategoryPath GOLANG_RECOVERED_TYPES_CATEGORYPATH =
		new CategoryPath("/golang-recovered");


	public static final String GOLANG_ABI_INTERNAL_CALLINGCONVENTION_NAME = "abi-internal";
	public static final String GOLANG_ABI0_CALLINGCONVENTION_NAME = "abi0";
	public static final String GOLANG_DUFFZERO_CALLINGCONVENTION_NAME = "duffzero";
	public static final String GOLANG_DUFFCOPY_CALLINGCONVENTION_NAME = "duffcopy";

	public static final String GOLANG_AUTOGENERATED_FILENAME = "<autogenerated>";
	
	/**
	 * Initial gcWriteBarrier scheme with signature {@code func gcWriteBarrier(val,dest)},
	 * x86-64 has gcWriteBarrierReg() variants.
	 */
	public static final GoVerRange GCWRITE_BUFFERED_VERS = GoVerRange.parse("-1.20");
	public static final String GOLANG_GCWRITE_BUFFERED_CALLINGCONVENTION_NAME = "gcwrite_buffered";
	public static final List<String> GCWRITE_BUFFERED_x86_64_Regs =
		List.of("CX", "DX", "BX", "BP", "SI", "R8", "R9"); // golang's names for registers

	/**
	 * Next gcWriteBarrier scheme with signature: {@code func gcWriteBarrier[1-8]() uintptr}
	 */
	public final static GoVerRange GCWRITE_BATCH_VERS = GoVerRange.parse("1.21-");
	public static final String GOLANG_GCWRITE_BATCH_CALLINGCONVENTION_NAME = "gcwrite_batch";

	public static final String GOLANG_RECEIVER_PARAM_NAME = "self";
	public static final String GOLANG_GENERICS_PARAM_NAME = "generics_dict";
	public static final String GOLANG_CLOSURE_CONTEXT_NAME = ".context";
}

