/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeProgramInterface;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeProgramInterface200;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeProgramInterface500;
import ghidra.app.util.bin.format.pdb2.pdbreader.TypeProgramInterface800;
import ghidra.util.exception.CancelledException;
import java.io.IOException;

public class TypeProgramInterfaceParser {
    private static final int TYPE_PROGRAM_INTERFACE_STREAM_NUMBER = 2;
    public static final int TI20_ID = 920924;
    public static final int TI40_ID = 19950410;
    public static final int TI41_ID = 19951122;
    public static final int TI42_ID = 19951204;
    public static final int TI50DEP_ID = 19960307;
    public static final int TI50_ID = 19961031;
    public static final int TI70_ID = 19990903;
    public static final int TI80_ID = 20040203;

    public TypeProgramInterface parse(AbstractPdb pdb) throws IOException, PdbException, CancelledException {
        int versionNumberSize = TypeProgramInterface.getVersionNumberSize();
        int streamNumber = this.getStreamNumber();
        PdbByteReader reader = pdb.getReaderForStreamNumber(streamNumber, 0, versionNumberSize);
        if (reader.getLimit() < versionNumberSize) {
            return null;
        }
        int versionNumber = TypeProgramInterface.deserializeVersionNumber(reader);
        return switch (versionNumber) {
            case 920924, 19950410, 19951122 -> new TypeProgramInterface200(pdb, this.getCategory(), streamNumber);
            case 19951204, 19960307 -> new TypeProgramInterface500(pdb, this.getCategory(), streamNumber);
            case 19961031, 19990903, 20040203 -> new TypeProgramInterface800(pdb, this.getCategory(), streamNumber);
            default -> {
                if (this.isReasonableError(versionNumber)) {
                    throw new PdbException("Unknown TPI Version: " + versionNumber);
                }
                yield null;
            }
        };
    }

    protected int getStreamNumber() {
        return 2;
    }

    protected RecordCategory getCategory() {
        return RecordCategory.TYPE;
    }

    protected boolean isReasonableError(int versionNumber) {
        return true;
    }
}

