/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.database.data.DataTypeUtilities;
import java.util.Comparator;

public class DataTypeNameComparator
implements Comparator<String> {
    public static final DataTypeNameComparator INSTANCE = new DataTypeNameComparator();

    @Override
    public int compare(String dt1Name, String dt2Name) {
        int conflict2;
        int len;
        String name1 = DataTypeUtilities.getNameWithoutConflict(dt1Name);
        String name2 = DataTypeUtilities.getNameWithoutConflict(dt2Name);
        int len1 = name1.length();
        int len2 = name2.length();
        int baseNameLen = len = Math.min(len1, len2);
        int baseCaseCompare = 0;
        for (int i = 0; i < len; ++i) {
            char c1 = name1.charAt(i);
            char c2 = name2.charAt(i);
            char lc1 = Character.toLowerCase(c1);
            char lc2 = Character.toLowerCase(c2);
            if (lc1 == ' ') {
                if (lc2 == ' ') {
                    baseNameLen = i;
                    break;
                }
                return -1;
            }
            if (lc2 == ' ') {
                return 1;
            }
            if (lc1 != lc2) {
                return lc1 - lc2;
            }
            if (baseCaseCompare != 0) continue;
            baseCaseCompare = c1 - c2;
        }
        if (len1 > baseNameLen && name1.charAt(baseNameLen) != ' ') {
            return 1;
        }
        if (len2 > baseNameLen && name2.charAt(baseNameLen) != ' ') {
            return -1;
        }
        if (baseCaseCompare != 0) {
            return baseCaseCompare;
        }
        int conflict1 = DataTypeUtilities.getConflictValue(dt1Name);
        if (conflict1 != (conflict2 = DataTypeUtilities.getConflictValue(dt2Name))) {
            return conflict1 - conflict2;
        }
        return name1.compareTo(name2);
    }
}

