/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.lang.Language;

public class MSP430_ElfExtension
extends ElfExtension {
    public static final int E_MSP430_MACH = 255;
    public static final int E_MSP430_MACH_MSP430X = 45;
    public static final ElfSectionHeaderType SHT_MSP430_ATTRIBUTES = new ElfSectionHeaderType(0x70000003, "SHT_MSP430_ATTRIBUTES", "Section contains ABI attributes");
    public static final ElfSectionHeaderType SHT_MSP430_SEC_FLAGS = new ElfSectionHeaderType(0x70000005, "SHT_MSP430_SEC_FLAGS", "Section contains compiler's section flags");
    public static final ElfSectionHeaderType SHT_MSP430_SYM_ALIASES = new ElfSectionHeaderType(0x70000006, "SHT_MSP430_SYM_ALIASES", "Section contains compiler's symbol aliases");
    public static final int OFBA_MSPABI_Tag_ISA = 4;
    public static final int OFBA_MSPABI_Tag_Code_Model = 6;
    public static final int OFBA_MSPABI_Tag_Data_Model = 8;
    public static final int OFBA_MSPABI_Tag_enum_size = 10;
    public static final int OFBA_MSPABI_Val_ISA_NONE = 0;
    public static final int OFBA_MSPABI_Val_ISA_MSP430 = 1;
    public static final int OFBA_MSPABI_Val_ISA_MSP430X = 2;
    public static final int OFBA_MSPABI_Val_Code_Model_NONE = 0;
    public static final int OFBA_MSPABI_Val_Code_Model_SMALL = 1;
    public static final int OFBA_MSPABI_Val_Code_Model_LARGE = 2;
    public static final int OFBA_MSPABI_Val_Data_Model_NONE = 0;
    public static final int OFBA_MSPABI_Val_Data_Model_SMALL = 1;
    public static final int OFBA_MSPABI_Val_Data_Model_LARGE = 2;
    public static final int OFBA_MSPABI_Val_Data_Model_RESTRICTED = 3;
    public static final int Val_GNU_MSP430_Data_Region_NONE = 0;
    public static final int Val_GNU_MSP430_Data_Region_Lower = 1;
    public static final int Val_GNU_MSP430_Data_Region_Any = 2;

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 105;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "TI_MSP430".equals(language.getProcessor().toString());
    }

    public String getDataTypeSuffix() {
        return "_MSP430";
    }

    public long getDefaultImageBase(ElfHeader elfHeader) {
        return 4096L;
    }
}

