/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.description;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.CallgraphEntry;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.RowKey;
import ghidra.features.bsim.query.description.SignatureRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FunctionDescription
implements Comparable<FunctionDescription> {
    private final ExecutableRecord exerec;
    private final String function_name;
    private final long address;
    private SignatureRecord sigrec;
    private List<CallgraphEntry> callrec;
    private RowKey id;
    private long vectorid;
    private int flags;

    public FunctionDescription(ExecutableRecord ex, String name, long addr) {
        this.exerec = ex;
        this.function_name = name;
        this.sigrec = null;
        this.id = null;
        this.vectorid = 0L;
        this.address = addr;
        this.flags = 0;
        this.callrec = null;
    }

    void setId(RowKey i) {
        this.id = i;
    }

    void setVectorId(long i) {
        this.vectorid = i;
    }

    void setFlags(int fl) {
        this.flags = fl;
    }

    void insertCall(FunctionDescription fd, int lhash) {
        if (this.callrec == null) {
            this.callrec = new ArrayList<CallgraphEntry>();
        }
        this.callrec.add(new CallgraphEntry(fd, lhash));
    }

    public void setSignatureRecord(SignatureRecord srec) {
        this.sigrec = srec;
    }

    public String getFunctionName() {
        return this.function_name;
    }

    public ExecutableRecord getExecutableRecord() {
        return this.exerec;
    }

    public SignatureRecord getSignatureRecord() {
        return this.sigrec;
    }

    public List<CallgraphEntry> getCallgraphRecord() {
        return this.callrec;
    }

    public RowKey getId() {
        return this.id;
    }

    public long getVectorId() {
        return this.vectorid;
    }

    public long getAddress() {
        return this.address;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean equals(Object obj) {
        FunctionDescription o = (FunctionDescription)obj;
        int comp = this.exerec.compareTo(o.exerec);
        if (comp != 0) {
            return false;
        }
        comp = this.function_name.compareTo(o.function_name);
        if (comp != 0) {
            return false;
        }
        comp = Long.compareUnsigned(this.address, o.address);
        return comp == 0;
    }

    public int hashCode() {
        int val = (int)(this.address >> 32) + this.exerec.hashCode();
        val *= 151;
        val ^= this.function_name.hashCode();
        val *= 13;
        return val ^= (int)this.address;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.function_name + " (" + this.exerec.getNameExec() + ")";
    }

    @Override
    public int compareTo(FunctionDescription o) {
        int comp = this.exerec.compareTo(o.exerec);
        if (comp != 0) {
            return comp;
        }
        comp = this.function_name.compareTo(o.function_name);
        if (comp != 0) {
            return comp;
        }
        comp = Long.compareUnsigned(this.address, o.address);
        return comp;
    }

    public void sortCallgraph() {
        int j;
        if (this.callrec == null || this.callrec.size() < 2) {
            return;
        }
        Collections.sort(this.callrec);
        int i = 1;
        for (j = 1; j < this.callrec.size(); ++j) {
            FunctionDescription callrecjm;
            FunctionDescription callrecj = this.callrec.get(j).getFunctionDescription();
            if (callrecj == (callrecjm = this.callrec.get(j - 1).getFunctionDescription())) continue;
            if (i != j) {
                this.callrec.set(i, this.callrec.get(j));
            }
            ++i;
        }
        if (i != this.callrec.size()) {
            for (j = this.callrec.size() - 1; j >= i; --j) {
                this.callrec.remove(j);
            }
        }
    }

    public String printRaw() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.function_name);
        buf.append(' ');
        buf.append(this.exerec.printRaw());
        return buf.toString();
    }

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append("<fdesc name=\"");
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.function_name);
        if (this.address != -1L) {
            fwrite.append("\" addr=\"0x").append(Long.toHexString(this.address));
        }
        if (this.sigrec != null && this.sigrec.getCount() > 0) {
            fwrite.append("\" sigdup=\"");
            fwrite.append(SpecXmlUtils.encodeUnsignedInteger((long)this.sigrec.getCount()));
        }
        fwrite.append("\">\n");
        if (this.sigrec != null) {
            this.sigrec.saveXml(fwrite);
        }
        if (this.callrec != null) {
            for (CallgraphEntry element : this.callrec) {
                element.saveXml(this, fwrite);
            }
        }
        if (this.flags != 0) {
            fwrite.append("<flags>");
            fwrite.append(SpecXmlUtils.encodeUnsignedInteger((long)this.flags));
            fwrite.append("</flags>\n");
        }
        fwrite.append("</fdesc>\n");
    }

    public boolean diffForUpdate(Update res, FunctionDescription fromDB) {
        res.function_name = !this.function_name.equals(fromDB.function_name);
        this.flags = 0xFFFFFFF9 & this.flags | fromDB.flags & 6;
        res.flags = this.flags != fromDB.flags;
        this.id = fromDB.id;
        res.update = this;
        return res.function_name || res.flags;
    }

    public static FunctionDescription restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory, DescriptionManager man, ExecutableRecord erec) throws LSHException {
        int count = 0;
        XmlElement el = parser.start(new String[]{"fdesc"});
        String fname = el.getAttribute("name");
        String addrString = el.getAttribute("addr");
        String sigdupstr = el.getAttribute("sigdup");
        long address = -1L;
        if (addrString != null) {
            address = SpecXmlUtils.decodeLong((String)addrString);
        }
        if (sigdupstr != null) {
            count = SpecXmlUtils.decodeInt((String)sigdupstr);
        }
        FunctionDescription fdesc = man.newFunctionDescription(fname, address, erec);
        if (parser.peek().isStart()) {
            if (parser.peek().getName().equals("lshcosine")) {
                SignatureRecord.restoreXml(parser, vectorFactory, man, fdesc, count);
            }
            while (parser.peek().isStart()) {
                String nm = parser.peek().getName();
                if (nm.equals("flags")) {
                    int flags;
                    parser.start(new String[0]);
                    fdesc.flags = flags = SpecXmlUtils.decodeInt((String)parser.end().getText());
                    continue;
                }
                CallgraphEntry.restoreXml(parser, man, fdesc);
            }
        }
        parser.end();
        return fdesc;
    }

    public static Map<Long, FunctionDescription> createAddressToFunctionMap(Iterator<FunctionDescription> iter) {
        TreeMap<Long, FunctionDescription> addrmap = new TreeMap<Long, FunctionDescription>();
        while (iter.hasNext()) {
            FunctionDescription func = iter.next();
            long addr = func.getAddress();
            if (addr == -1L) continue;
            addrmap.put(addr, func);
        }
        return addrmap;
    }

    public static List<Update> generateUpdates(Iterator<FunctionDescription> iter, Map<Long, FunctionDescription> addrMap, List<FunctionDescription> badList) {
        ArrayList<Update> updateList = new ArrayList<Update>();
        Update curupdate = new Update();
        while (iter.hasNext()) {
            FunctionDescription newfunc = iter.next();
            long addr = newfunc.getAddress();
            if (addr == -1L) continue;
            FunctionDescription oldfunc = addrMap.get(addr);
            if (oldfunc == null) {
                badList.add(newfunc);
                continue;
            }
            if (!newfunc.diffForUpdate(curupdate, oldfunc)) continue;
            updateList.add(curupdate);
            curupdate = new Update();
        }
        return updateList;
    }

    public static class Update {
        public FunctionDescription update;
        public boolean function_name;
        public boolean flags;
    }
}

