/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.quickmethod;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.oat.quickmethod.OatQuickMethodHeader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class OatQuickMethodHeader_S_T
extends OatQuickMethodHeader {
    public static final int kShouldDeoptimizeMask = Integer.MIN_VALUE;
    public static final int kIsCodeInfoMask = 0x40000000;
    public static final int kCodeInfoMask = 0x3FFFFFFF;
    public static final int kCodeSizeMask = 0x3FFFFFFF;
    private int data_;

    OatQuickMethodHeader_S_T(BinaryReader reader) throws IOException {
        this.data_ = reader.readNextInt();
    }

    public int getData() {
        return this.data_;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(OatQuickMethodHeader_S_T.class.getSimpleName(), 0);
        structure.add(DWORD, "data_", null);
        structure.setCategoryPath(new CategoryPath("/oat"));
        return structure;
    }

    @Override
    public int getCodeSize() {
        return this.data_ & 0x3FFFFFFF;
    }
}

