/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.op;

import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.op.JitDefOp;
import ghidra.pcode.emu.jit.op.JitSyntheticOp;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import java.util.List;

public record JitSynthSubPieceOp(JitOutVar out, int offset, JitVal v) implements JitDefOp,
JitSyntheticOp
{
    public JitSynthSubPieceOp {
        if (offset < 0) {
            throw new IllegalArgumentException("Subpiece offset cannot be negative");
        }
        if (offset + out.size() > v.size()) {
            throw new IllegalArgumentException("Subpiece is outside input");
        }
        if (v.size() == out.size() && offset == 0) {
            throw new IllegalArgumentException("Subpiece is whole input");
        }
    }

    @Override
    public void link() {
        JitDefOp.super.link();
        this.v.addUse(this, 0);
    }

    @Override
    public void unlink() {
        JitDefOp.super.link();
        this.v.removeUse(this, 0);
    }

    @Override
    public List<JitVal> inputs() {
        return List.of(this.v);
    }

    public JitTypeBehavior vType() {
        return JitTypeBehavior.INTEGER;
    }

    @Override
    public JitTypeBehavior type() {
        return JitTypeBehavior.INTEGER;
    }

    @Override
    public JitTypeBehavior typeFor(int position) {
        switch (position) {
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.vType();
    }

    public boolean abuts(JitSynthSubPieceOp right) {
        int diff = this.offset() - right.offset();
        return right.out().size() == diff && this.v() == right.v();
    }
}

