/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingServicePlugin;
import ghidra.app.plugin.core.debug.service.modules.InfoPerProgram;
import ghidra.app.plugin.core.debug.service.modules.MappingEntry;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.Msg;
import ghidra.util.database.spatial.rect.Rectangle2D;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

class InfoPerTrace
extends TraceDomainObjectListener {
    private final DebuggerStaticMappingServicePlugin plugin;
    final Trace trace;
    final Map<TraceStaticMapping, MappingEntry> outboundByEntry = new HashMap<TraceStaticMapping, MappingEntry>();
    final NavigableMap<TraceAddressSnapRange, MappingEntry> outboundByRange = new TreeMap<TraceAddressSnapRange, MappingEntry>(Comparator.comparing(TraceAddressSnapRange::getX1));
    final MultiValuedMap<URL, MappingEntry> outboundByStaticUrl = new HashSetValuedHashMap();
    private volatile boolean needsResync = false;

    InfoPerTrace(DebuggerStaticMappingServicePlugin plugin, Trace trace) {
        this.plugin = plugin;
        this.trace = trace;
        this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, e -> this.objectRestored());
        this.listenFor((TraceEvent)TraceEvents.MAPPING_ADDED, this::staticMappingAdded);
        this.listenFor((TraceEvent)TraceEvents.MAPPING_DELETED, this::staticMappingDeleted);
        trace.addListener((DomainObjectListener)this);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        super.domainObjectChanged(ev);
        if (this.needsResync) {
            this.needsResync = false;
            CompletableFuture.runAsync(this::resyncEntries, this.plugin.executor);
        }
    }

    private void objectRestored() {
        this.needsResync = true;
    }

    private void staticMappingAdded(TraceStaticMapping mapping) {
        this.needsResync = true;
    }

    private void staticMappingDeleted(TraceStaticMapping mapping) {
        this.needsResync = true;
    }

    public void dispose() {
        this.trace.removeListener((DomainObjectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resyncEntries() {
        try (DebuggerStaticMappingServicePlugin.ChangeCollector cc = new DebuggerStaticMappingServicePlugin.ChangeCollector(this.plugin);){
            Object object = this.plugin.lock;
            synchronized (object) {
                this.resyncEntries(cc);
            }
        }
    }

    void resyncEntries(DebuggerStaticMappingServicePlugin.ChangeCollector cc) {
        Set<TraceStaticMapping> oldEntries = this.outboundByEntry.keySet();
        Set curEntries = this.trace.getStaticMappingManager().getAllEntries().stream().filter(e -> !e.isDeleted()).collect(Collectors.toSet());
        Set<TraceStaticMapping> removed = DebuggerStaticMappingServicePlugin.ChangeCollector.subtract(oldEntries, curEntries);
        Set<TraceStaticMapping> added = DebuggerStaticMappingServicePlugin.ChangeCollector.subtract(curEntries, oldEntries);
        this.processRemovedEntries(cc, removed);
        this.processAddedEntries(cc, added);
    }

    void removeEntries(DebuggerStaticMappingServicePlugin.ChangeCollector cc) {
        this.processRemovedEntries(cc, Set.copyOf(this.outboundByEntry.keySet()));
    }

    private void processRemovedEntries(DebuggerStaticMappingServicePlugin.ChangeCollector cc, Set<TraceStaticMapping> removed) {
        for (TraceStaticMapping entry : removed) {
            this.processRemovedEntry(cc, entry);
        }
    }

    private void processRemovedEntry(DebuggerStaticMappingServicePlugin.ChangeCollector cc, TraceStaticMapping entry) {
        MappingEntry me = this.outboundByEntry.remove(entry);
        if (me == null) {
            return;
        }
        this.outboundByRange.remove(me.getTraceAddressSnapRange());
        this.outboundByStaticUrl.removeMapping((Object)me.getStaticProgramUrl(), (Object)me);
        this.plugin.checkAndClearProgram(cc, me);
    }

    private void processAddedEntries(DebuggerStaticMappingServicePlugin.ChangeCollector cc, Set<TraceStaticMapping> added) {
        for (TraceStaticMapping entry : added) {
            this.processAddedEntry(cc, entry);
        }
    }

    private void processAddedEntry(DebuggerStaticMappingServicePlugin.ChangeCollector cc, TraceStaticMapping entry) {
        MappingEntry me = new MappingEntry(entry);
        this.outboundByEntry.put(entry, me);
        this.outboundByRange.put(me.getTraceAddressSnapRange(), me);
        this.outboundByStaticUrl.put((Object)me.getStaticProgramUrl(), (Object)me);
        this.plugin.checkAndFillProgram(cc, me);
    }

    void clearEntriesForProgram(DebuggerStaticMappingServicePlugin.ChangeCollector cc, InfoPerProgram progInfo) {
        for (MappingEntry me : this.outboundByStaticUrl.get((Object)progInfo.url)) {
            progInfo.clearProgram(cc, me);
        }
    }

    void fillEntriesForProgram(DebuggerStaticMappingServicePlugin.ChangeCollector cc, InfoPerProgram progInfo) {
        for (MappingEntry me : this.outboundByStaticUrl.get((Object)progInfo.url)) {
            progInfo.fillProgram(cc, me);
        }
    }

    Set<Program> getOpenMappedProgramsAtSnap(long snap) {
        HashSet<Program> result = new HashSet<Program>();
        for (Map.Entry out : this.outboundByRange.entrySet()) {
            MappingEntry me = (MappingEntry)out.getValue();
            if (me.mapping.isDeleted()) {
                Msg.warn((Object)((Object)this), (Object)("Encountered deleted mapping: " + String.valueOf(me.mapping)));
                continue;
            }
            if (!me.isStaticProgramOpen() || !((TraceAddressSnapRange)out.getKey()).getLifespan().contains(snap)) continue;
            result.add(me.program);
        }
        return result;
    }

    ProgramLocation getOpenMappedProgramLocation(Address address, Lifespan span) {
        ImmutableTraceAddressSnapRange tasr = new ImmutableTraceAddressSnapRange(address, span);
        for (MappingEntry me : this.outboundByRange.headMap((TraceAddressSnapRange)tasr, true).values()) {
            if (me.mapping.isDeleted()) {
                Msg.warn((Object)((Object)this), (Object)("Encountered deleted mapping: " + String.valueOf(me.mapping)));
                continue;
            }
            if (!tasr.intersects((Rectangle2D)me.getTraceAddressSnapRange()) || !me.isStaticProgramOpen()) continue;
            return me.mapTraceAddressToProgramLocation(address);
        }
        return null;
    }

    private void collectOpenMappedViews(Map<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> result, AddressRange rng, Lifespan span) {
        ImmutableTraceAddressSnapRange tasr = new ImmutableTraceAddressSnapRange(rng, span);
        ImmutableTraceAddressSnapRange max = new ImmutableTraceAddressSnapRange(rng.getMaxAddress(), span);
        for (MappingEntry me : this.outboundByRange.headMap((TraceAddressSnapRange)max, true).values()) {
            if (me.mapping.isDeleted()) {
                Msg.warn((Object)((Object)this), (Object)("Encountered deleted mapping: " + String.valueOf(me.mapping)));
                continue;
            }
            if (me.program == null || !tasr.intersects((Rectangle2D)me.getTraceAddressSnapRange())) continue;
            AddressRange srcRng = me.getTraceRange().intersect(rng);
            AddressRange dstRng = me.mapTraceRangeToProgram(rng);
            result.computeIfAbsent(me.program, p -> new TreeSet()).add(new DebuggerStaticMappingService.MappedAddressRange(srcRng, dstRng));
        }
    }

    Map<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(AddressSetView set, Lifespan span) {
        HashMap<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> result = new HashMap<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>>();
        for (AddressRange rng : set) {
            this.collectOpenMappedViews(result, rng, span);
        }
        return Collections.unmodifiableMap(result);
    }

    private void collectMappedProgramUrlsInView(Set<URL> result, AddressRange rng, Lifespan span) {
        ImmutableTraceAddressSnapRange tasr = new ImmutableTraceAddressSnapRange(rng, span);
        ImmutableTraceAddressSnapRange max = new ImmutableTraceAddressSnapRange(rng.getMaxAddress(), span);
        for (MappingEntry me : this.outboundByRange.headMap((TraceAddressSnapRange)max, true).values()) {
            if (me.mapping.isDeleted()) {
                Msg.warn((Object)((Object)this), (Object)("Encountered deleted mapping: " + String.valueOf(me.mapping)));
                continue;
            }
            if (!tasr.intersects((Rectangle2D)me.getTraceAddressSnapRange())) continue;
            result.add(me.getStaticProgramUrl());
        }
    }

    Set<URL> getMappedProgramUrlsInView(AddressSetView set, Lifespan span) {
        HashSet<URL> result = new HashSet<URL>();
        for (AddressRange rng : set) {
            this.collectMappedProgramUrlsInView(result, rng, span);
        }
        return Collections.unmodifiableSet(result);
    }
}

