/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.ObjectStorage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ObjectStorageStreamAdapter
implements ObjectStorage {
    ObjectOutputStream out;
    ObjectInputStream in;

    public ObjectStorageStreamAdapter(ObjectOutputStream out) {
        this.out = out;
    }

    public ObjectStorageStreamAdapter(ObjectInputStream in) {
        this.in = in;
    }

    @Override
    public void putInt(int value) {
        try {
            this.out.writeInt(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putByte(byte value) {
        try {
            this.out.writeByte(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putShort(short value) {
        try {
            this.out.writeShort(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putLong(long value) {
        try {
            this.out.writeLong(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putString(String value) {
        try {
            this.out.writeObject(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putBoolean(boolean value) {
        try {
            this.out.writeBoolean(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putFloat(float value) {
        try {
            this.out.writeFloat(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putDouble(double value) {
        try {
            this.out.writeDouble(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getInt() {
        try {
            return this.in.readInt();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public byte getByte() {
        try {
            return this.in.readByte();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public short getShort() {
        try {
            return this.in.readShort();
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public long getLong() {
        try {
            return this.in.readLong();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean getBoolean() {
        try {
            return this.in.readBoolean();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String getString() {
        try {
            return (String)this.in.readObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public float getFloat() {
        try {
            return this.in.readFloat();
        }
        catch (IOException e) {
            return 0.0f;
        }
    }

    @Override
    public double getDouble() {
        try {
            return this.in.readDouble();
        }
        catch (IOException e) {
            return 0.0;
        }
    }

    @Override
    public void putInts(int[] value) {
        try {
            if (value == null) {
                this.out.writeInt(-1);
                return;
            }
            this.out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                this.out.writeInt(value[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putBytes(byte[] value) {
        try {
            if (value == null) {
                this.out.writeInt(-1);
                return;
            }
            this.out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                this.out.writeByte(value[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putShorts(short[] value) {
        try {
            if (value == null) {
                this.out.writeInt(-1);
                return;
            }
            this.out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                this.out.writeShort(value[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putLongs(long[] value) {
        try {
            if (value == null) {
                this.out.writeInt(-1);
                return;
            }
            this.out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                this.out.writeLong(value[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putFloats(float[] value) {
        try {
            if (value == null) {
                this.out.writeInt(-1);
                return;
            }
            this.out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                this.out.writeFloat(value[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putDoubles(double[] value) {
        try {
            if (value == null) {
                this.out.writeInt(-1);
                return;
            }
            this.out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                this.out.writeDouble(value[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void putStrings(String[] value) {
        try {
            if (value == null) {
                this.out.writeInt(-1);
                return;
            }
            this.out.writeInt(value.length);
            for (int i = 0; i < value.length; ++i) {
                this.out.writeObject(value[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int[] getInts() {
        try {
            int n = this.in.readInt();
            if (n < 0) {
                return null;
            }
            int[] r = new int[n];
            for (int i = 0; i < n; ++i) {
                r[i] = this.in.readInt();
            }
            return r;
        }
        catch (IOException e) {
            return new int[0];
        }
    }

    @Override
    public byte[] getBytes() {
        try {
            int n = this.in.readInt();
            if (n < 0) {
                return null;
            }
            byte[] r = new byte[n];
            for (int i = 0; i < n; ++i) {
                r[i] = this.in.readByte();
            }
            return r;
        }
        catch (IOException e) {
            return new byte[0];
        }
    }

    @Override
    public short[] getShorts() {
        try {
            int n = this.in.readInt();
            if (n < 0) {
                return null;
            }
            short[] r = new short[n];
            for (int i = 0; i < n; ++i) {
                r[i] = this.in.readShort();
            }
            return r;
        }
        catch (IOException e) {
            return new short[0];
        }
    }

    @Override
    public long[] getLongs() {
        try {
            int n = this.in.readInt();
            if (n < 0) {
                return null;
            }
            long[] r = new long[n];
            for (int i = 0; i < n; ++i) {
                r[i] = this.in.readLong();
            }
            return r;
        }
        catch (IOException e) {
            return new long[0];
        }
    }

    @Override
    public float[] getFloats() {
        try {
            int n = this.in.readInt();
            if (n < 0) {
                return null;
            }
            float[] r = new float[n];
            for (int i = 0; i < n; ++i) {
                r[i] = this.in.readFloat();
            }
            return r;
        }
        catch (IOException e) {
            return new float[0];
        }
    }

    @Override
    public double[] getDoubles() {
        try {
            int n = this.in.readInt();
            if (n < 0) {
                return null;
            }
            double[] r = new double[n];
            for (int i = 0; i < n; ++i) {
                r[i] = this.in.readDouble();
            }
            return r;
        }
        catch (IOException e) {
            return new double[0];
        }
    }

    @Override
    public String[] getStrings() {
        try {
            int n = this.in.readInt();
            if (n < 0) {
                return null;
            }
            String[] r = new String[n];
            for (int i = 0; i < n; ++i) {
                r[i] = (String)this.in.readObject();
            }
            return r;
        }
        catch (Exception e) {
            return new String[0];
        }
    }
}

