/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Array;
import ghidra.util.datastruct.DataTable;
import java.io.Serializable;

public class ObjectArray
implements Array,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int MIN_SIZE = 4;
    Object[] objs;
    int lastNonZeroIndex = -1;

    public ObjectArray() {
        this.objs = new Object[4];
    }

    public ObjectArray(int size) {
        this.objs = new Object[size < 4 ? 4 : size];
    }

    public void put(int index, Object value) {
        if (value == null) {
            this.remove(index);
            return;
        }
        if (index >= this.objs.length) {
            this.adjustArray(Math.max(index + 1, this.objs.length * 2));
        }
        this.objs[index] = value;
        if (index > this.lastNonZeroIndex) {
            this.lastNonZeroIndex = index;
        }
    }

    @Override
    public void remove(int index) {
        if (index >= this.objs.length) {
            return;
        }
        this.objs[index] = null;
        if (index == this.lastNonZeroIndex) {
            this.lastNonZeroIndex = this.findLastNonZeroIndex();
        }
        if (this.lastNonZeroIndex < this.objs.length / 4) {
            this.adjustArray(this.lastNonZeroIndex * 2);
        }
    }

    private int findLastNonZeroIndex() {
        for (int i = this.lastNonZeroIndex; i >= 0; --i) {
            if (this.objs[i] == null) continue;
            return i;
        }
        return -1;
    }

    public Object get(int index) {
        if (index < this.objs.length) {
            return this.objs[index];
        }
        return null;
    }

    private void adjustArray(int size) {
        if (size < 4) {
            size = 4;
        }
        Object[] newobjs = new Object[size];
        int len = Math.min(size, this.objs.length);
        System.arraycopy(this.objs, 0, newobjs, 0, len);
        this.objs = newobjs;
    }

    @Override
    public int getLastNonEmptyIndex() {
        return this.lastNonZeroIndex;
    }

    @Override
    public void copyDataTo(int index, DataTable table, int toIndex, int toCol) {
        table.putObject(toIndex, toCol, this.get(index));
    }
}

