/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.NDS32_ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class NDS32_ElfRelocationHandler
extends AbstractElfRelocationHandler<NDS32_ElfRelocationType, ElfRelocationContext<?>> {
    public NDS32_ElfRelocationHandler() {
        super(NDS32_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 167;
    }

    public int getRelrRelocationType() {
        return NDS32_ElfRelocationType.R_NDS32_RELATIVE.typeId;
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, NDS32_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        ElfRelocationContext<?> nds32RelocationContext = elfRelocationContext;
        int symbolIndex = relocation.getSymbolIndex();
        return this.doRelocate(nds32RelocationContext, type, symbolIndex, relocation, relocationAddress);
    }

    private RelocationResult doRelocate(ElfRelocationContext<?> nds32RelocationContext, NDS32_ElfRelocationType type, int symbolIndex, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException {
        Program program = nds32RelocationContext.getProgram();
        Memory memory = program.getMemory();
        MessageLog log = nds32RelocationContext.getLog();
        ElfSymbol elfSymbol = nds32RelocationContext.getSymbol(symbolIndex);
        long symbolValue = nds32RelocationContext.getSymbolValue(elfSymbol);
        String symbolName = elfSymbol.getNameAsString();
        int oldValue = memory.getInt(relocationAddress, true);
        long addend = 0L;
        if (relocation.hasAddend()) {
            addend = relocation.getAddend();
        }
        int value = 0;
        int newValue = 0;
        int byteLength = 4;
        switch (type) {
            case R_NDS32_HI20_RELA: {
                value = (int)(symbolValue + addend);
                newValue = oldValue & 0xFFF00000 | value >> 12;
                memory.setInt(relocationAddress, newValue, true);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_NDS32_LO12S0_RELA: {
                value = (int)(symbolValue + addend);
                newValue = oldValue & 0xFFFFF000 | value & 0xFFF;
                memory.setInt(relocationAddress, newValue, true);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
        }
        return RelocationResult.UNSUPPORTED;
    }
}

