/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.nav;

import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.features.base.memsearch.bytesource.AddressableByteSource;
import ghidra.features.base.memsearch.bytesource.ProgramByteSource;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import javax.swing.Icon;

public interface Navigatable {
    public static final long DEFAULT_NAVIGATABLE_ID = -1L;

    public long getInstanceID();

    public boolean goTo(Program var1, ProgramLocation var2);

    default public boolean goTo(ProgramLocation location) {
        return this.goTo(location.getProgram(), location);
    }

    public ProgramLocation getLocation();

    public Program getProgram();

    public LocationMemento getMemento();

    public void setMemento(LocationMemento var1);

    public Icon getNavigatableIcon();

    public boolean isConnected();

    default public boolean isDynamic() {
        return false;
    }

    public boolean supportsMarkers();

    public void requestFocus();

    public boolean isVisible();

    public void setSelection(ProgramSelection var1);

    public void setHighlight(ProgramSelection var1);

    public ProgramSelection getSelection();

    public ProgramSelection getHighlight();

    public String getTextSelection();

    public void addNavigatableListener(NavigatableRemovalListener var1);

    public void removeNavigatableListener(NavigatableRemovalListener var1);

    public boolean isDisposed();

    public boolean supportsHighlight();

    public void setHighlightProvider(ListingHighlightProvider var1, Program var2);

    public void removeHighlightProvider(ListingHighlightProvider var1, Program var2);

    default public AddressableByteSource getByteSource() {
        return new ProgramByteSource(this.getProgram());
    }
}

