/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.UsrException;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class ArrayAction
extends CompositeEditorTableAction {
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.array");
    public static final String ACTION_NAME = "Create Array";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Create an array";
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(91, 0);
    private static String[] POPUP_PATH = new String[]{"Create Array"};

    public ArrayAction(CompositeEditorProvider<?, ?> provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        try {
            this.model.createArray();
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage());
        }
        this.requestTableFocus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.hasIncompleteFieldEntry() && this.model.isArrayAllowed();
    }
}

