/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.fallthrough;

import docking.DialogComponentProvider;
import docking.widgets.button.GRadioButton;
import docking.widgets.label.GDLabel;
import generic.theme.Gui;
import ghidra.app.plugin.core.fallthrough.FallThroughModel;
import ghidra.app.plugin.core.fallthrough.FallThroughPlugin;
import ghidra.app.util.AddressInput;
import ghidra.program.model.address.Address;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import resources.Icons;

class FallThroughDialog
extends DialogComponentProvider
implements ChangeListener {
    private JLabel addressLabel;
    private JLabel instLabel;
    private JButton homeButton;
    private FallThroughPlugin plugin;
    private FallThroughModel model;
    private AddressInput addrField;
    private JRadioButton defaultRB;
    private JRadioButton userRB;
    private boolean changing;

    FallThroughDialog(FallThroughPlugin plugin, FallThroughModel model) {
        super("Set Fallthrough Address", true);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Set Fallthrough"));
        this.plugin = plugin;
        this.model = model;
        this.addWorkPanel(this.create());
        this.addOKButton();
        this.addApplyButton();
        this.addCancelButton();
        this.updateState();
        model.setChangeListener(this);
    }

    protected void applyCallback() {
        this.model.execute();
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        if (this.model.execute()) {
            this.cancelCallback();
        }
    }

    public void updateState() {
        String msg;
        Address addr = this.model.getAddress();
        if (addr == null) {
            this.cancelCallback();
            return;
        }
        this.changing = true;
        this.addressLabel.setText(addr.toString());
        this.instLabel.setText(this.model.getInstructionRepresentation());
        if (this.model.isDefaultFallthrough()) {
            this.defaultRB.setSelected(true);
        } else if (this.model.isUserDefinedFallthrough()) {
            this.userRB.setSelected(true);
        }
        Address ftAddr = this.model.getCurrentFallthrough();
        if (ftAddr != null) {
            if (!ftAddr.equals((Object)this.addrField.getAddress())) {
                this.addrField.setAddress(ftAddr);
            }
        } else {
            this.addrField.clear();
        }
        boolean enabled = this.model.allowAddressEdits();
        this.addrField.setEnabled(enabled);
        this.changing = false;
        if (this.model.isValidInput()) {
            this.setOkEnabled(true);
            this.setApplyEnabled(true);
        }
        if ((msg = this.model.getMessage()) != null) {
            this.setStatusText(msg);
        }
    }

    private void addressChanged(Address address) {
        if (this.changing) {
            return;
        }
        Runnable r = () -> {
            if (address != null || this.addrField.getText().length() == 0) {
                this.model.setCurrentFallthrough(address);
            } else {
                this.setStatusText("Invalid Address");
                this.setOkEnabled(false);
                this.setApplyEnabled(false);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private JPanel create() {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.addrField = new AddressInput(this.model.getProgram(), this::addressChanged);
        this.addrField.addActionListener(e -> this.model.setCurrentFallthrough(this.addrField.getAddress()));
        panel.add((Component)this.createHomePanel(), "North");
        panel.add((Component)this.createAddressPanel(), "Center");
        panel.getAccessibleContext().setAccessibleName("Override Fallthrough");
        return panel;
    }

    private JPanel createAddressPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Fallthrough Address"));
        panel.add((Component)this.addrField, "North");
        panel.add((Component)this.createRadioButtonPanel(), "Center");
        panel.getAccessibleContext().setAccessibleName("Address");
        return panel;
    }

    private JPanel createHomePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder("Home"));
        this.addressLabel = new GDLabel("01001000");
        Font monoFont = Gui.getFont((String)"font.monospaced");
        this.addressLabel.setFont(monoFont);
        this.instLabel = new GDLabel("jmp DAT_01001000");
        this.instLabel.setFont(monoFont);
        this.homeButton = this.createButton("Home");
        this.homeButton.addActionListener(e -> this.plugin.goTo(this.model.getAddress()));
        this.homeButton.getAccessibleContext().setAccessibleName("Home");
        JPanel innerPanel = new JPanel();
        BoxLayout bl = new BoxLayout(innerPanel, 0);
        innerPanel.setLayout(bl);
        innerPanel.add(Box.createHorizontalStrut(5));
        innerPanel.add(this.homeButton);
        innerPanel.add(Box.createHorizontalStrut(10));
        innerPanel.add(this.addressLabel);
        innerPanel.add(Box.createHorizontalStrut(20));
        innerPanel.add(this.instLabel);
        innerPanel.add(Box.createHorizontalStrut(10));
        innerPanel.getAccessibleContext().setAccessibleName("Home Content");
        panel.add((Component)innerPanel, "Center");
        panel.getAccessibleContext().setAccessibleName("Home");
        return panel;
    }

    private JPanel createRadioButtonPanel() {
        JPanel panel = new JPanel();
        BoxLayout bl = new BoxLayout(panel, 0);
        panel.setLayout(bl);
        ButtonGroup group = new ButtonGroup();
        this.defaultRB = new GRadioButton("Default", true);
        this.defaultRB.addActionListener(ev -> this.model.defaultSelected());
        this.defaultRB.setToolTipText("Use default fallthrough address");
        this.defaultRB.getAccessibleContext().setAccessibleName("Default");
        this.userRB = new GRadioButton("User", false);
        this.userRB.addActionListener(ev -> this.model.userSelected());
        this.userRB.setToolTipText("Override default fallthrough address");
        this.userRB.getAccessibleContext().setAccessibleName("User");
        group.add(this.defaultRB);
        group.add(this.userRB);
        panel.add(this.defaultRB);
        panel.add(this.userRB);
        panel.getAccessibleContext().setAccessibleName("Radio Buttons");
        JPanel outerPanel = new JPanel(new FlowLayout(1));
        outerPanel.add(panel);
        outerPanel.getAccessibleContext().setAccessibleName("Radio Button");
        return outerPanel;
    }

    private JButton createButton(String altText) {
        JButton button = new JButton();
        Icon icon = Icons.HOME_ICON;
        button = new JButton(icon);
        Insets noInsets = new Insets(0, 0, 0, 0);
        button.setMargin(noInsets);
        button.setToolTipText("Go back to home address");
        button.getAccessibleContext().setAccessibleName("Home");
        return button;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateState();
    }
}

