/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import generic.expressions.ExpressionEvaluator;
import generic.expressions.ExpressionException;
import generic.expressions.ExpressionValue;
import generic.expressions.LongExpressionValue;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.macro.DWARFMacroHeader;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroDefine;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroImport;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroInfoEntry;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroUndef;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DWARFMacroEnumCreator {
    private DWARFProgram dprog;
    private Set<String> processedMacros;
    public static final String ENUM_PATH = "_DEFINES_";

    public DWARFMacroEnumCreator(DWARFProgram dprog) {
        this.dprog = dprog;
        this.processedMacros = new HashSet<String>();
    }

    public void createEnumsFromMacroInfo(boolean includeCommandLineDefines, TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.dprog.getCompilationUnits().size());
        CategoryPath catPath = DWARFProgram.DWARF_ROOT_CATPATH.extend(new String[]{ENUM_PATH});
        for (DWARFCompilationUnit cu : this.dprog.getCompilationUnits()) {
            monitor.increment();
            monitor.setMessage("DWARF: Processing Macros for " + cu.getName());
            HashMap<String, ExpressionValue> macrosToValues = new HashMap<String, ExpressionValue>();
            this.createEnums(cu.getMacros(), macrosToValues, catPath, includeCommandLineDefines, monitor);
        }
    }

    private void createEnums(DWARFMacroHeader macroHeader, Map<String, ExpressionValue> macrosToValues, CategoryPath catPath, boolean includeCommandLineDefines, TaskMonitor monitor) throws IOException, CancelledException {
        ProgramBasedDataTypeManager dtManager = this.dprog.getGhidraProgram().getDataTypeManager();
        DWARFImportSummary importSummary = this.dprog.getImportSummary();
        for (DWARFMacroInfoEntry macroEntry : macroHeader.getEntries()) {
            DWARFMacroInfoEntry dWARFMacroInfoEntry;
            monitor.checkCancelled();
            Objects.requireNonNull(macroEntry);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DWARFMacroUndef.class, DWARFMacroDefine.class, DWARFMacroImport.class}, (Object)dWARFMacroInfoEntry, n)) {
                case 0: {
                    DWARFMacroUndef undef = (DWARFMacroUndef)dWARFMacroInfoEntry;
                    macrosToValues.remove(undef.getMacroInfo().symbolName());
                    break;
                }
                case 1: {
                    String symbolName;
                    DWARFMacroDefine define = (DWARFMacroDefine)dWARFMacroInfoEntry;
                    DWARFMacroDefine.MacroInfo macroInfo = define.getMacroInfo();
                    if (macroInfo.isFunctionLike() || !includeCommandLineDefines && define.getLineNumber() == 0 || this.processedMacros.contains(symbolName = macroInfo.symbolName())) break;
                    this.processedMacros.add(symbolName);
                    try {
                        ExpressionEvaluator evaluator = new ExpressionEvaluator(s -> (ExpressionValue)macrosToValues.get(s));
                        long value = evaluator.parseAsLong(macroInfo.definition());
                        macrosToValues.put(symbolName, (ExpressionValue)new LongExpressionValue(value));
                        EnumDataType enumDT = new EnumDataType(catPath, "define_" + symbolName, 8, (DataTypeManager)dtManager);
                        enumDT.add(symbolName, value, macroHeader.getCompilationUnit().getName());
                        ++importSummary.numEnumsCreated;
                        enumDT.setLength(enumDT.getMinimumPossibleLength());
                        dtManager.addDataType((DataType)enumDT, DataTypeConflictHandler.KEEP_HANDLER);
                    }
                    catch (ExpressionException expressionException) {}
                    break;
                }
                case 2: {
                    DWARFMacroImport importMacro = (DWARFMacroImport)dWARFMacroInfoEntry;
                    this.createEnums(importMacro.getImportedMacroHeader(), macrosToValues, catPath, includeCommandLineDefines, monitor);
                    break;
                }
            }
        }
    }
}

