/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.dwarf.DIEAggregate;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFFunction;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.dwarf.DWARFVariable;
import ghidra.app.util.bin.format.dwarf.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.app.util.bin.format.golang.GoFunctionFixup;
import ghidra.app.util.bin.format.golang.GoFunctionMultiReturn;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.classfinder.ExtensionPointProperties;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@ExtensionPointProperties(priority=4000)
public class GolangDWARFFunctionFixup
implements DWARFFunctionFixup {
    public static final CategoryPath GOLANG_API_EXPORT = new CategoryPath(CategoryPath.ROOT, new String[]{"GolangAPIExport"});
    private static final String GOLANG_FUNC_INFO_PREFIX = "Golang function info: ";
    private GoRttiMapper goBinary;

    public static boolean isGolangFunction(DWARFFunction dfunc) {
        DIEAggregate diea = dfunc.diea;
        int cuLang = diea.getCompilationUnit().getLanguage();
        if (cuLang != 22) {
            return false;
        }
        return dfunc.retval.isVoidType();
    }

    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) throws DWARFException {
        String ccName;
        if (!GolangDWARFFunctionFixup.isGolangFunction(dfunc) || !this.initGoBinaryContext(dfunc, TaskMonitor.DUMMY)) {
            return;
        }
        GoFuncData funcData = this.goBinary.getFunctionData(dfunc.address);
        if (funcData == null) {
            this.appendComment(dfunc.function, GOLANG_FUNC_INFO_PREFIX, "No function data");
            dfunc.signatureCommitMode = DWARFFunction.CommitMode.SKIP;
            return;
        }
        if (!funcData.getFlags().isEmpty()) {
            dfunc.signatureCommitMode = DWARFFunction.CommitMode.SKIP;
            return;
        }
        ProgramBasedDataTypeManager dtm = this.goBinary.getProgram().getDataTypeManager();
        GoParamStorageAllocator storageAllocator = this.goBinary.newStorageAllocator();
        if (this.goBinary.isGolangAbi0Func(dfunc.function)) {
            storageAllocator.setAbi0Mode();
        }
        String string = ccName = storageAllocator.isAbi0Mode() ? "abi0" : "abi-internal";
        if (this.goBinary.hasCallingConvention(ccName)) {
            dfunc.callingConventionName = ccName;
        }
        GoFunctionMultiReturn multiReturnInfo = this.fixupFormalFuncDef(dfunc, storageAllocator, (DataTypeManager)dtm);
        this.fixupCustomStorage(dfunc, storageAllocator, (DataTypeManager)dtm, multiReturnInfo);
    }

    private GoFunctionMultiReturn fixupFormalFuncDef(DWARFFunction dfunc, GoParamStorageAllocator storageAllocator, DataTypeManager dtm) {
        ArrayList<DWARFVariable> realParams = new ArrayList<DWARFVariable>();
        ArrayList<DWARFVariable> returnParams = new ArrayList<DWARFVariable>();
        HashSet<String> returnParamNames = new HashSet<String>();
        for (DWARFVariable dvar : dfunc.params) {
            if (dvar.isOutputParameter) {
                if (returnParamNames.contains(dvar.name.getName())) continue;
                returnParamNames.add(dvar.name.getName());
                returnParams.add(dvar);
                continue;
            }
            realParams.add(dvar);
        }
        VoidDataType returnType = VoidDataType.dataType;
        GoFunctionMultiReturn multiReturn = null;
        if (returnParams.size() == 1) {
            returnType = ((DWARFVariable)returnParams.get((int)0)).type;
        } else if (returnParams.size() > 1) {
            multiReturn = new GoFunctionMultiReturn(GoConstants.GOLANG_CATEGORYPATH, returnParams, dfunc, dtm, storageAllocator);
            returnType = multiReturn.getStruct();
        }
        dfunc.retval = DWARFVariable.fromDataType(dfunc, (DataType)returnType);
        dfunc.params = realParams;
        dfunc.varArg = false;
        return multiReturn;
    }

    private void fixupCustomStorage(DWARFFunction dfunc, GoParamStorageAllocator storageAllocator, DataTypeManager dtm, GoFunctionMultiReturn multiReturn) {
        Program program = this.goBinary.getProgram();
        ArrayList<DWARFVariable> spillVars = new ArrayList<DWARFVariable>();
        for (DWARFVariable dvar : dfunc.params) {
            List<Register> regStorage = storageAllocator.getRegistersFor(dvar.type);
            if (regStorage != null && !regStorage.isEmpty()) {
                dvar.setRegisterStorage(regStorage);
                spillVars.add(dvar);
                if (!(dvar.type instanceof Structure) || dvar.getStorageSize() == dvar.type.getLength()) continue;
                dfunc.getProgram().logWarningAt(dfunc.address, dfunc.name.getName(), "Go known storage allocation problem: param \"%s\" register allocation for structs missing inter-field padding.".formatted(dvar.name.getName()));
                continue;
            }
            if (!dvar.isZeroByte()) {
                long stackOffset = storageAllocator.getStackAllocation(dvar.type);
                dvar.setStackStorage(stackOffset);
                continue;
            }
            if (dvar.isEmptyArray()) {
                dvar.type = GoFunctionFixup.makeEmptyArrayDataType(dvar.type);
            }
            Address zerobaseAddress = GoRttiMapper.getZerobaseAddress(program);
            dvar.setRamStorage(zerobaseAddress.getOffset());
        }
        storageAllocator.alignStack();
        storageAllocator.resetRegAllocation();
        if (!dfunc.retval.isZeroByte()) {
            dfunc.retval.clearStorage();
            if (multiReturn != null) {
                for (DataTypeComponent dtc : multiReturn.getComponentsInOriginalOrder()) {
                    this.allocateReturnStorage(dfunc, dfunc.retval, dtc.getFieldName() + "_return_result_alias", dtc.getDataType(), storageAllocator, false);
                }
                if (!program.getMemory().isBigEndian()) {
                    List<Varnode> varnodes = dfunc.retval.getVarnodes();
                    GoFunctionFixup.reverseNonStackStorageLocations(varnodes);
                    dfunc.retval.setVarnodes(varnodes);
                }
            } else {
                this.allocateReturnStorage(dfunc, dfunc.retval, "return_value_alias_variable", dfunc.retval.type, storageAllocator, true);
            }
        } else {
            if (dfunc.retval.isEmptyArray()) {
                dfunc.retval.type = GoFunctionFixup.makeEmptyArrayDataType(dfunc.retval.type);
            }
            if (!dfunc.retval.isVoidType()) {
                dfunc.retval.setRamStorage(GoRttiMapper.getZerobaseAddress(program).getOffset());
            }
        }
        storageAllocator.alignStack();
        for (DWARFVariable dvar : spillVars) {
            DWARFVariable spill = DWARFVariable.fromDataType(dfunc, dvar.type);
            String paramName = dvar.name.getName() + "_spill";
            spill.name = dvar.name.replaceName(paramName, paramName);
            spill.setStackStorage(storageAllocator.getStackAllocation(spill.type));
            dfunc.localVars.add(spill);
        }
        dfunc.localVarErrors = false;
        dfunc.signatureCommitMode = DWARFFunction.CommitMode.STORAGE;
    }

    private void allocateReturnStorage(DWARFFunction dfunc, DWARFVariable dvar, String name, DataType dt, GoParamStorageAllocator storageAllocator, boolean allowEndianFixups) {
        List<Register> regStorage = storageAllocator.getRegistersFor(dt, allowEndianFixups);
        if (regStorage != null && !regStorage.isEmpty()) {
            dvar.addRegisterStorage(regStorage);
        } else if (!DWARFUtil.isZeroByteDataType(dt)) {
            long stackOffset = storageAllocator.getStackAllocation(dt);
            dvar.addStackStorage(stackOffset, dt.getLength());
            dfunc.localVars.add(this.createReturnResultAliasVar(dfunc, dt, name, stackOffset));
        }
    }

    private DWARFVariable createReturnResultAliasVar(DWARFFunction dfunc, DataType dataType, String name, long stackOffset) {
        DWARFVariable returnResultVar = DWARFVariable.fromDataType(dfunc, dataType);
        returnResultVar.name = dfunc.name.createChild(name, name, SymbolType.LOCAL_VAR);
        returnResultVar.setStackStorage(stackOffset);
        return returnResultVar;
    }

    private boolean initGoBinaryContext(DWARFFunction dfunc, TaskMonitor monitor) {
        if (this.goBinary == null) {
            Program program = dfunc.getProgram().getGhidraProgram();
            this.goBinary = GoRttiMapper.getSharedGoBinary(program, monitor);
        }
        return this.goBinary != null;
    }

    private void appendComment(Function func, String prefix, String comment) {
        DWARFUtil.appendComment(this.goBinary.getProgram(), func.getEntryPoint(), CommentType.PLATE, prefix, comment, "\n");
    }
}

