/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class RoutinesCommand
extends LoadCommand {
    private long init_address;
    private long init_module;
    private long reserved1;
    private long reserved2;
    private long reserved3;
    private long reserved4;
    private long reserved5;
    private long reserved6;
    private boolean is32bit;

    RoutinesCommand(BinaryReader reader, boolean is32bit) throws IOException {
        super(reader);
        this.is32bit = is32bit;
        if (is32bit) {
            this.init_address = reader.readNextUnsignedInt();
            this.init_module = reader.readNextUnsignedInt();
            this.reserved1 = reader.readNextUnsignedInt();
            this.reserved2 = reader.readNextUnsignedInt();
            this.reserved3 = reader.readNextUnsignedInt();
            this.reserved4 = reader.readNextUnsignedInt();
            this.reserved5 = reader.readNextUnsignedInt();
            this.reserved6 = reader.readNextUnsignedInt();
        } else {
            this.init_address = reader.readNextLong();
            this.init_module = reader.readNextLong();
            this.reserved1 = reader.readNextLong();
            this.reserved2 = reader.readNextLong();
            this.reserved3 = reader.readNextLong();
            this.reserved4 = reader.readNextLong();
            this.reserved5 = reader.readNextLong();
            this.reserved6 = reader.readNextLong();
        }
    }

    public long getInitializationRoutineAddress() {
        return this.init_address;
    }

    public long getInitializationRoutineModuleIndex() {
        return this.init_module;
    }

    public long getReserved1() {
        return this.reserved1;
    }

    public long getReserved2() {
        return this.reserved2;
    }

    public long getReserved3() {
        return this.reserved3;
    }

    public long getReserved4() {
        return this.reserved4;
    }

    public long getReserved5() {
        return this.reserved5;
    }

    public long getReserved6() {
        return this.reserved6;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        if (this.is32bit) {
            struct.add(DWORD, "init_address", null);
            struct.add(DWORD, "init_module", null);
            struct.add(DWORD, "reserved1", null);
            struct.add(DWORD, "reserved2", null);
            struct.add(DWORD, "reserved3", null);
            struct.add(DWORD, "reserved4", null);
            struct.add(DWORD, "reserved5", null);
            struct.add(DWORD, "reserved6", null);
        } else {
            struct.add(QWORD, "init_address", null);
            struct.add(QWORD, "init_module", null);
            struct.add(QWORD, "reserved1", null);
            struct.add(QWORD, "reserved2", null);
            struct.add(QWORD, "reserved3", null);
            struct.add(QWORD, "reserved4", null);
            struct.add(QWORD, "reserved5", null);
            struct.add(QWORD, "reserved6", null);
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "routines_command";
    }
}

