/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.pe.MachineName;
import ghidra.app.util.bin.format.pe.OffsetValidator;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.app.util.bin.format.pe.debug.DebugDirectoryParser;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;

public class SeparateDebugHeader
implements OffsetValidator {
    public static final int IMAGE_SEPARATE_DEBUG_SIGNATURE = 18756;
    public static final int IMAGE_SEPARATE_DEBUG_SIGNATURE_MAC = 17481;
    private short signature;
    private short flags;
    private short machine;
    private short characteristics;
    private int timeDateStamp;
    private int checkSum;
    private int imageBase;
    private int sizeOfImage;
    private int numberOfSections;
    private int exportedNamesSize;
    private int debugDirectorySize;
    private int sectionAlignment;
    private int[] reserved = new int[2];
    private SectionHeader[] sections;
    private DebugDirectoryParser parser;

    public SeparateDebugHeader(ByteProvider bp) throws IOException {
        String str;
        BinaryReader reader = new BinaryReader(bp, true);
        reader.setPointerIndex(0);
        this.signature = reader.readNextShort();
        if (this.signature != 18756) {
            return;
        }
        this.flags = reader.readNextShort();
        this.machine = reader.readNextShort();
        this.characteristics = reader.readNextShort();
        this.timeDateStamp = reader.readNextInt();
        this.checkSum = reader.readNextInt();
        this.imageBase = reader.readNextInt();
        this.sizeOfImage = reader.readNextInt();
        this.numberOfSections = reader.readNextInt();
        this.exportedNamesSize = reader.readNextInt();
        this.debugDirectorySize = reader.readNextInt();
        this.sectionAlignment = reader.readNextInt();
        this.reserved = reader.readNextIntArray(2);
        if (this.numberOfSections > 65536) {
            Msg.error((Object)this, (Object)("Number of sections " + this.numberOfSections));
            return;
        }
        long ptr = reader.getPointerIndex();
        this.sections = new SectionHeader[this.numberOfSections];
        for (int i = 0; i < this.numberOfSections; ++i) {
            this.sections[i] = SectionHeader.readSectionHeader(reader, ptr, -1L);
            ptr += 40L;
        }
        BinaryReader stringReader = reader.clone(ptr);
        ArrayList<String> exportedNameslist = new ArrayList<String>();
        while (!(str = stringReader.readNextAsciiString()).isEmpty()) {
            exportedNameslist.add(str);
        }
        this.parser = new DebugDirectoryParser(reader, ptr += (long)this.exportedNamesSize, this.debugDirectorySize, this.sizeOfImage);
    }

    public short getCharacteristics() {
        return this.characteristics;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public int getDebugDirectorySize() {
        return this.debugDirectorySize;
    }

    public int getExportedNamesSize() {
        return this.exportedNamesSize;
    }

    public short getFlags() {
        return this.flags;
    }

    public int getImageBase() {
        return this.imageBase;
    }

    public short getMachine() {
        return this.machine;
    }

    public String getMachineName() {
        return MachineName.getName(this.machine);
    }

    public int getNumberOfSections() {
        return this.numberOfSections;
    }

    public int[] getReserved() {
        return this.reserved;
    }

    public int getSectionAlignment() {
        return this.sectionAlignment;
    }

    public short getSignature() {
        return this.signature;
    }

    public int getSizeOfImage() {
        return this.sizeOfImage;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public DebugDirectoryParser getParser() {
        return this.parser;
    }

    @Override
    public boolean checkPointer(long ptr) {
        for (int i = 0; i < this.sections.length; ++i) {
            long rawSize = Integer.toUnsignedLong(this.sections[i].getSizeOfRawData());
            long rawPtr = Integer.toUnsignedLong(this.sections[i].getPointerToRawData());
            if (ptr < rawPtr || ptr > rawPtr + rawSize) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkRVA(long rva) {
        return 0L <= rva && rva <= (long)this.sizeOfImage;
    }
}

