/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format;

import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.MnemonicFieldFactory;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.Map;

public class FieldFactoryNameMapper {
    private static Map<String, FieldFactory> deprecatedFieldNameToFactoryMap;

    public static FieldFactory getFactoryPrototype(String fieldName, FieldFactory[] prototypeFactories) {
        if (fieldName == null) {
            return null;
        }
        for (int i = 0; i < prototypeFactories.length; ++i) {
            if (!prototypeFactories[i].getFieldName().equals(fieldName)) continue;
            return prototypeFactories[i];
        }
        Map<String, FieldFactory> deprecatedfactories = FieldFactoryNameMapper.getDeprecatedFieldFactories();
        return deprecatedfactories.get(fieldName.toLowerCase());
    }

    private static Map<String, FieldFactory> getDeprecatedFieldFactories() {
        if (deprecatedFieldNameToFactoryMap == null) {
            deprecatedFieldNameToFactoryMap = new HashMap<String, FieldFactory>();
            deprecatedFieldNameToFactoryMap.put("mnemonic", FieldFactoryNameMapper.createInstance(MnemonicFieldFactory.class));
        }
        return deprecatedFieldNameToFactoryMap;
    }

    private static FieldFactory createInstance(Class<? extends FieldFactory> factoryClass) {
        try {
            return factoryClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (Exception e) {
            Msg.error(FieldFactoryNameMapper.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }
}

