/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.Iterator;

class EquatesXmlMgr {
    private MessageLog log;
    private EquateTable equateTable;

    EquatesXmlMgr(Program program, MessageLog log) {
        this.log = log;
        this.equateTable = program.getEquateTable();
    }

    void read(XmlPullParser parser, TaskMonitor monitor) throws CancelledException {
        XmlElement element = parser.next();
        while (true) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            element = parser.peek();
            if (element == null || !element.getName().equals("EQUATE_GROUP")) break;
            this.processEquateGroup(parser, monitor);
        }
        element = parser.next();
    }

    void write(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing EQUATES ...");
        writer.startElement("EQUATES");
        writer.startElement("EQUATE_GROUP");
        Iterator iter = this.equateTable.getEquates();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Equate equate = (Equate)iter.next();
            this.writeEquate(writer, equate, set);
        }
        writer.endElement("EQUATE_GROUP");
        writer.endElement("EQUATES");
    }

    private void processEquateGroup(XmlPullParser parser, TaskMonitor monitor) {
        XmlElement element = parser.next();
        while (!monitor.isCancelled()) {
            element = parser.peek();
            if (element.getName().equals("DISPLAY_SETTINGS") || element.getName().equals("REGULAR_CMT") || element.getName().equals("REPEATABLE_CMT") || element.getName().equals("BIT_MASK")) {
                element = parser.next();
                element = parser.next();
                continue;
            }
            if (!element.getName().equals("EQUATE")) break;
            this.processEquate(parser, element);
        }
        element = parser.next();
    }

    private void processEquate(XmlPullParser parser, XmlElement element) {
        if (!element.isStart()) {
            return;
        }
        element = parser.next();
        String name = element.getAttribute("NAME");
        long value = XmlUtilities.parseLong((String)element.getAttribute("VALUE"));
        try {
            this.equateTable.createEquate(name, value);
        }
        catch (DuplicateNameException e) {
            Equate eq = this.equateTable.getEquate(name);
            long prevVal = eq.getValue();
            if (prevVal != value) {
                this.log.appendMsg("Cannot create equate [" + name + "] with value [" + Long.toHexString(value) + "]; previously defined with value [" + Long.toHexString(prevVal) + "]");
            }
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
        element = parser.peek();
        if (element.getName().equals("REGULAR_CMT")) {
            element = parser.next();
            element = parser.next();
        }
        if ((element = parser.peek()).getName().equals("REPEATABLE_CMT")) {
            element = parser.next();
            element = parser.next();
        }
        element = parser.next();
    }

    private void writeEquate(XmlWriter writer, Equate equate, AddressSetView set) {
        boolean okToWrite = false;
        if (set == null) {
            okToWrite = true;
        } else {
            EquateReference[] refs = equate.getReferences();
            for (int i = 0; i < refs.length; ++i) {
                if (!set.contains(refs[i].getAddress())) continue;
                okToWrite = true;
                break;
            }
        }
        if (okToWrite) {
            XmlAttributes attrs = new XmlAttributes();
            attrs.addAttribute("NAME", equate.getName());
            attrs.addAttribute("VALUE", equate.getValue(), true);
            writer.startElement("EQUATE", attrs);
            writer.endElement("EQUATE");
        }
    }
}

