/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import docking.ActionContext;
import docking.PopupMenuHandler;
import docking.action.DockingActionIf;
import docking.action.MultiActionDockingActionIf;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.menu.MenuHandler;
import docking.menu.MenuManager;
import docking.menu.MultiActionDockingAction;
import docking.menu.MultipleActionDockingToolbarButton;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;

public class LaunchAction
extends MultiActionDockingAction {
    public static final String NAME = "Launch";
    public static final Icon ICON = DebuggerResources.ICON_DEBUGGER;
    public static final String GROUP = "Dbg1. General";
    public static final String HELP_ANCHOR = "launch_tracermi";
    private final TraceRmiLauncherServicePlugin plugin;
    private MenuActionDockingToolbarButton button;

    public LaunchAction(TraceRmiLauncherServicePlugin plugin) {
        super(NAME, plugin.getName());
        this.plugin = plugin;
        this.setToolBarData(new ToolBarData(ICON, GROUP, "A"));
        this.setHelpLocation(new HelpLocation(plugin.getName(), HELP_ANCHOR));
    }

    protected String[] prependConfigAndLaunch(List<String> menuPath) {
        Program program = this.plugin.currentProgram;
        String title = program == null ? "Configure and Launch ..." : "Configure and Launch %s using...".formatted(TraceRmiLauncherServicePlugin.getProgramName(program));
        return (String[])Stream.concat(Stream.of(title), menuPath.stream()).toArray(String[]::new);
    }

    public List<DockingActionIf> getActionList(ActionContext context) {
        Program program = this.plugin.currentProgram;
        Collection<TraceRmiLaunchOffer> offers = this.plugin.getOffers(program);
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>();
        Map<String, Long> saved = this.plugin.loadSavedConfigs(program);
        for (TraceRmiLaunchOffer offer : offers) {
            actions.add((DockingActionIf)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(offer.getConfigName(), this.plugin.getName()).popupMenuPath(this.prependConfigAndLaunch(offer.getMenuPath()))).popupMenuGroup(offer.getMenuGroup(), offer.getMenuOrder())).popupMenuIcon(offer.getIcon())).helpLocation(offer.getHelpLocation())).enabledWhen(ctx -> !offer.requiresImage() || program != null)).onAction(ctx -> this.plugin.configureAndLaunch(offer))).build());
            Long last = saved.get(offer.getConfigName());
            if (last == null) continue;
            String title = program == null ? "Re-launch " + offer.getTitle() : "Re-launch %s using %s".formatted(TraceRmiLauncherServicePlugin.getProgramName(program), offer.getTitle());
            actions.add((DockingActionIf)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(offer.getConfigName(), this.plugin.getName()).popupMenuPath(new String[]{title})).popupMenuGroup("0", "%016x".formatted(Long.MAX_VALUE - last))).popupMenuIcon(offer.getIcon())).helpLocation(offer.getHelpLocation())).enabledWhen(ctx -> true)).onAction(ctx -> this.plugin.relaunch((ActionContext)ctx, offer))).build());
        }
        return actions;
    }

    public JButton doCreateButton() {
        this.button = new MenuActionDockingToolbarButton((MultiActionDockingActionIf)this);
        return this.button;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.plugin.getOffers(this.plugin.currentProgram).isEmpty();
    }

    public void actionPerformed(ActionContext context) {
        TraceRmiLauncherServicePlugin.ConfigLast last = this.plugin.findMostRecentConfig(this.plugin.currentProgram);
        TraceRmiLaunchOffer offer = this.plugin.findOffer(last);
        if (offer == null) {
            Swing.runLater(() -> this.button.showPopup());
            return;
        }
        this.plugin.relaunch(context, offer);
    }

    public String getDescription() {
        Program program = this.plugin.currentProgram;
        TraceRmiLauncherServicePlugin.ConfigLast last = this.plugin.findMostRecentConfig(program);
        TraceRmiLaunchOffer offer = this.plugin.findOffer(last);
        if (offer == null && program == null) {
            return "Configure and launch";
        }
        if (offer == null) {
            return "Configure and launch " + TraceRmiLauncherServicePlugin.getProgramName(program);
        }
        if (program == null) {
            return "Re-launch " + offer.getTitle();
        }
        return "Re-launch %s using %s".formatted(TraceRmiLauncherServicePlugin.getProgramName(program), offer.getTitle());
    }

    class MenuActionDockingToolbarButton
    extends MultipleActionDockingToolbarButton {
        public MenuActionDockingToolbarButton(MultiActionDockingActionIf action) {
            super(action);
        }

        protected JPopupMenu doCreateMenu() {
            ActionContext context = this.getActionContext();
            List<DockingActionIf> actionList = LaunchAction.this.getActionList(context);
            PopupMenuHandler handler = new PopupMenuHandler(LaunchAction.this.plugin.getTool().getWindowManager(), context);
            MenuManager manager = new MenuManager(LaunchAction.NAME, '\u0000', LaunchAction.GROUP, true, (MenuHandler)handler, null);
            for (DockingActionIf action : actionList) {
                action.setEnabled(action.isEnabledForContext(context));
                manager.addAction(action);
            }
            return manager.getPopupMenu();
        }

        protected JPopupMenu showPopup() {
            return super.showPopup();
        }

        public String getToolTipText() {
            return LaunchAction.this.getDescription();
        }
    }
}

