/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jgrapht.Graph;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.util.BoundingRectangleCollector;
import org.jungrapht.visualization.util.ChangeEventSupport;

public class BoundingRectanglePaintable<V>
implements VisualizationServer.Paintable {
    protected RenderContext rc;
    protected Graph<V, ?> graph;
    protected LayoutModel<V> layoutModel;
    protected List<Rectangle2D> rectangles;

    public BoundingRectanglePaintable(RenderContext rc, LayoutModel<V> layoutModel) {
        this.rc = rc;
        this.layoutModel = layoutModel;
        this.graph = layoutModel.getGraph();
        BoundingRectangleCollector.Vertices brc = new BoundingRectangleCollector.Vertices(rc.getVertexShapeFunction(), layoutModel);
        this.rectangles = brc.getRectangles();
        if (layoutModel instanceof ChangeEventSupport) {
            ((ChangeEventSupport)layoutModel).addChangeListener(e -> {
                brc.compute();
                this.rectangles = brc.getRectangles();
            });
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g.setColor(Color.cyan);
        for (Rectangle2D r : this.rectangles) {
            g2d.draw(this.rc.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, r));
        }
    }

    @Override
    public boolean useTransform() {
        return true;
    }
}

