/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.buffers.BlockStreamHandle;
import db.buffers.BufferFile;
import db.buffers.BufferFileHandle;
import db.buffers.DataBuffer;
import db.buffers.InputBlockStream;
import db.buffers.OutputBlockStream;
import ghidra.util.Msg;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.util.NoSuchElementException;

public class BufferFileAdapter
implements BufferFile {
    private BufferFileHandle bufferFileHandle;

    public BufferFileAdapter(BufferFileHandle remoteBufferFile) {
        this.bufferFileHandle = remoteBufferFile;
    }

    @Override
    public int getParameter(String name) throws NoSuchElementException, IOException {
        return this.bufferFileHandle.getParameter(name);
    }

    @Override
    public void setParameter(String name, int value) throws IOException {
        this.bufferFileHandle.setParameter(name, value);
    }

    @Override
    public void clearParameters() throws IOException {
        this.bufferFileHandle.clearParameters();
    }

    @Override
    public String[] getParameterNames() throws IOException {
        return this.bufferFileHandle.getParameterNames();
    }

    @Override
    public int getBufferSize() throws IOException {
        return this.bufferFileHandle.getBufferSize();
    }

    @Override
    public int getIndexCount() throws IOException {
        return this.bufferFileHandle.getIndexCount();
    }

    @Override
    public int[] getFreeIndexes() throws IOException {
        return this.bufferFileHandle.getFreeIndexes();
    }

    @Override
    public void setFreeIndexes(int[] indexes) throws IOException {
        this.bufferFileHandle.setFreeIndexes(indexes);
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return this.bufferFileHandle.isReadOnly();
    }

    @Override
    public boolean setReadOnly() throws IOException {
        return this.bufferFileHandle.setReadOnly();
    }

    @Override
    public void close() throws IOException {
        this.bufferFileHandle.close();
    }

    @Override
    public boolean delete() throws IOException {
        return this.bufferFileHandle.delete();
    }

    @Override
    public void dispose() {
        block2: {
            try {
                this.bufferFileHandle.dispose();
            }
            catch (IOException e) {
                if (e instanceof NoSuchObjectException || e instanceof ConnectException) break block2;
                Msg.error((Object)this, (Object)e);
            }
        }
    }

    @Override
    public DataBuffer get(DataBuffer buf, int index) throws IOException {
        DataBuffer remoteBuf = this.bufferFileHandle.get(index);
        if (buf == null) {
            return remoteBuf;
        }
        buf.setEmpty(remoteBuf.isEmpty());
        buf.setId(remoteBuf.getId());
        if (remoteBuf.data != null) {
            buf.data = remoteBuf.data;
        }
        return buf;
    }

    @Override
    public void put(DataBuffer buf, int index) throws IOException {
        this.bufferFileHandle.put(buf, index);
    }

    public boolean isRemote() {
        return this.bufferFileHandle instanceof Remote;
    }

    InputBlockStream getInputBlockStream() throws IOException {
        if (this.isRemote()) {
            BlockStreamHandle<InputBlockStream> inputBlockStreamHandle = this.bufferFileHandle.getInputBlockStreamHandle();
            return inputBlockStreamHandle.openBlockStream();
        }
        return this.bufferFileHandle.getInputBlockStream();
    }

    OutputBlockStream getOutputBlockStream(int blockCount) throws IOException {
        if (this.isRemote()) {
            BlockStreamHandle<OutputBlockStream> outputBlockStreamHandle = this.bufferFileHandle.getOutputBlockStreamHandle(blockCount);
            return outputBlockStreamHandle.openBlockStream();
        }
        return this.bufferFileHandle.getOutputBlockStream(blockCount);
    }
}

