/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.layout.ObservableCachingLayout;
import edu.uci.ics.jung.visualization.layout.PersistentLayout;
import edu.uci.ics.jung.visualization.util.Caching;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PersistentLayoutImpl<V, E>
extends ObservableCachingLayout<V, E>
implements PersistentLayout<V, E>,
ChangeEventSupport,
Caching {
    protected Map<V, PersistentLayout.Point> locations;
    protected Set<V> dontmove;
    protected boolean locked;

    public PersistentLayoutImpl(Layout<V, E> layout) {
        super(layout);
        this.locations = Maps.asMap((Set)ImmutableSet.copyOf(layout.getGraph().getVertices()), new RandomPointFactory(this.getSize()));
        this.dontmove = new HashSet<V>();
    }

    protected void initializeLocations() {
        for (Object v : this.getGraph().getVertices()) {
            Point2D coord = (Point2D)this.delegate.apply(v);
            if (this.dontmove.contains(v)) continue;
            this.initializeLocation(v, coord);
        }
    }

    protected void initializeLocation(V v, Point2D coord) {
        PersistentLayout.Point point = this.locations.get(v);
        coord.setLocation(point.x, point.y);
    }

    @Override
    public void persist(String fileName) throws IOException {
        for (Object v : this.getGraph().getVertices()) {
            PersistentLayout.Point p = new PersistentLayout.Point(this.transform(v));
            this.locations.put((PersistentLayout.Point)v, p);
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));
        oos.writeObject(this.locations);
        oos.close();
    }

    @Override
    public void restore(String fileName) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));
        this.locations = (Map)ois.readObject();
        ois.close();
        this.initializeLocations();
        this.locked = true;
        this.fireStateChanged();
    }

    @Override
    public void lock(boolean locked) {
        this.locked = locked;
    }

    @Override
    public boolean done() {
        return super.done() || this.locked;
    }

    public void lock(V v, boolean state) {
        this.dontmove.add(v);
        this.delegate.lock(v, state);
    }

    public static class RandomPointFactory<V>
    implements Function<V, PersistentLayout.Point>,
    Serializable {
        Dimension d;

        public RandomPointFactory(Dimension d) {
            this.d = d;
        }

        public PersistentLayout.Point apply(V v) {
            double x = Math.random() * (double)this.d.width;
            double y = Math.random() * (double)this.d.height;
            return new PersistentLayout.Point(x, y);
        }
    }
}

