/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.ThreadInfo;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ThreadInfoListStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_THREAD_INFO_LIST";
    private int sizeOfHeader;
    private int sizeOfEntry;
    private int numberOfEntries;
    private ThreadInfo[] entries;
    private DumpFileReader reader;
    private long index;

    ThreadInfoListStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSizeOfHeader(this.reader.readNextInt());
        this.setSizeOfEntry(this.reader.readNextInt());
        this.setNumberOfEntries(this.reader.readNextInt());
        this.entries = new ThreadInfo[this.numberOfEntries];
        for (int i = 0; i < this.numberOfEntries; ++i) {
            this.setThreadInfo(new ThreadInfo(this.reader, this.reader.getPointerIndex()), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "SizeOfHeader", null);
        struct.add(DWORD, 4, "SizeOfEntry", null);
        struct.add(DWORD, 4, "NumberOfThreads", null);
        DataType t = this.entries[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.numberOfEntries, t.getLength());
        struct.add((DataType)a, a.getLength(), "Threads", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public void setSizeOfHeader(int sizeOfHeader) {
        this.sizeOfHeader = sizeOfHeader;
    }

    public int getSizeOfHeader() {
        return this.sizeOfHeader;
    }

    public void setSizeOfEntry(int sizeOfEntry) {
        this.sizeOfEntry = sizeOfEntry;
    }

    public int getSizeOfEntry() {
        return this.sizeOfEntry;
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public void setNumberOfEntries(int numberOfEntries) {
        this.numberOfEntries = numberOfEntries;
    }

    public ThreadInfo getThreadInfo(int idx) {
        return this.entries[idx];
    }

    public void setThreadInfo(ThreadInfo thread, int index) {
        this.entries[index] = thread;
    }
}

