/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class SetExternalRefCmd
implements Command<Program> {
    private Address fromAddr;
    private int opIndex;
    private String extName;
    private String extLabel;
    private Address extAddr;
    private String errMsg;
    private RefType refType;
    private SourceType source;

    public SetExternalRefCmd(Address fromAddr, int opIndex, String extName, String extLabel, Address extAddr, RefType refType, SourceType source) {
        this.fromAddr = fromAddr;
        this.opIndex = opIndex;
        this.extName = extName;
        this.extLabel = extLabel;
        this.extAddr = extAddr;
        this.refType = refType;
        this.source = source;
    }

    @Deprecated
    public SetExternalRefCmd(Address fromAddr, int opIndex, String extName, String extLabel, Address extAddr, SourceType source) {
        this(fromAddr, opIndex, extName, extLabel, extAddr, RefType.DATA, source);
    }

    public boolean applyTo(Program program) {
        ReferenceManager refMgr = program.getReferenceManager();
        try {
            refMgr.addExternalReference(this.fromAddr, this.extName, this.extLabel, this.extAddr, this.source, this.opIndex, this.refType);
            return true;
        }
        catch (DuplicateNameException e) {
            this.errMsg = e.getMessage();
        }
        catch (InvalidInputException e) {
            this.errMsg = e.getMessage();
        }
        return false;
    }

    public String getStatusMsg() {
        return this.errMsg;
    }

    public String getName() {
        return "Set External Reference";
    }
}

