/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.bookmark;

import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.services.MarkerDescriptor;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.BookmarkType;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MarkerLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.Swing;
import java.awt.Color;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;

public class BookmarkNavigator {
    private static final int BIG_CHANGE = 1000;
    static final Icon NOTE_ICON = new GIcon("icon.plugin.bookmark.type.note");
    static final Icon INFO_ICON = new GIcon("icon.plugin.bookmark.type.info");
    static final Icon WARNING_ICON = new GIcon("icon.plugin.bookmark.type.warning");
    static final Icon ERROR_ICON = new GIcon("icon.plugin.bookmark.type.error");
    static final Icon ANALYSIS_ICON = new GIcon("icon.plugin.bookmark.type.analysis");
    static final Icon DEFAULT_ICON = new GIcon("icon.plugin.bookmark.type.default");
    static final int NOTE_PRIORITY = 0;
    static final int ERROR_PRIORITY = 1000;
    static final int WARNING_PRIORITY = 500;
    static final int INFO_PRIORITY = 4;
    static final int ANALYSIS_PRIORITY = 6;
    static final int DEFAULT_PRIORITY = 8;
    static final Color NOTE_COLOR = new GColor("color.bg.plugin.bookmark.note");
    static final Color INFO_COLOR = new GColor("color.bg.plugin.bookmark.info");
    static final Color WARNING_COLOR = new GColor("color.bg.plugin.bookmark.warning");
    static final Color ERROR_COLOR = new GColor("color.bg.plugin.bookmark.error");
    static final Color ANALYSIS_COLOR = new GColor("color.bg.plugin.bookmark.analysis");
    static final Color DEFAULT_COLOR = new GColor("color.bg.plugin.bookmark.default");
    private String type;
    private MarkerService markerService;
    private BookmarkManager bookmarkMgr;
    private MarkerSet markerSet;
    private Runnable updateRunnable;
    private AddressSet addressSet;

    public BookmarkNavigator(MarkerService markerService, BookmarkManager bookmarkManager, BookmarkType bmt) {
        Color color;
        Icon icon;
        this.markerService = markerService;
        this.bookmarkMgr = bookmarkManager;
        this.type = bmt.getTypeString();
        this.updateRunnable = () -> this.updateMarkerSetAddresses();
        int priority = bmt.getMarkerPriority();
        if (priority < 0) {
            priority = 8;
        }
        if ((icon = bmt.getIcon()) == null && bookmarkManager.isDefinedType(this.type)) {
            icon = DEFAULT_ICON;
        }
        if ((color = bmt.getMarkerColor()) == null) {
            color = DEFAULT_COLOR;
        }
        String markerName = this.type + " Bookmarks";
        this.markerSet = icon != null ? markerService.createPointMarker(markerName, markerName, this.bookmarkMgr.getProgram(), priority, true, true, false, color, icon) : markerService.createAreaMarker(markerName, markerName, this.bookmarkMgr.getProgram(), priority, false, true, false, color);
        this.markerSet.setMarkerDescriptor(new MarkerDescriptor(){

            @Override
            public String getTooltip(MarkerLocation loc) {
                Bookmark[] bookmarks = BookmarkNavigator.this.bookmarkMgr.getBookmarks(loc.getAddr(), BookmarkNavigator.this.type);
                if (bookmarks == null) {
                    return BookmarkNavigator.this.type;
                }
                StringBuilder buffy = new StringBuilder();
                for (int i = 0; i < bookmarks.length; ++i) {
                    if (i != 0) {
                        buffy.append("<br>");
                    }
                    buffy.append(BookmarkNavigator.this.type);
                    String cat = bookmarks[i].getCategory();
                    if (!StringUtils.isBlank((CharSequence)cat)) {
                        buffy.append(" [");
                        buffy.append(HTMLUtilities.escapeHTML((String)cat));
                        buffy.append("]");
                    }
                    buffy.append(": ");
                    buffy.append(HTMLUtilities.escapeHTML((String)bookmarks[i].getComment()));
                }
                return buffy.toString();
            }
        });
    }

    private synchronized void updateMarkerSetAddresses() {
        if (this.addressSet != null && this.markerSet != null) {
            this.markerSet.setAddressSet((AddressSetView)this.addressSet);
            this.addressSet = null;
        }
    }

    public void dispose() {
        if (this.markerService != null) {
            this.markerService.removeMarker(this.markerSet, this.bookmarkMgr.getProgram());
            this.markerSet = null;
            this.bookmarkMgr = null;
        }
    }

    String getType() {
        return this.type;
    }

    public synchronized void updateBookmarkers(AddressSet set) {
        if (this.addressSet != null) {
            this.addressSet = set;
            return;
        }
        this.addressSet = set;
        Swing.runLater((Runnable)this.updateRunnable);
    }

    public void add(Address addr) {
        this.markerSet.add(addr);
    }

    public void clear(Address addr) {
        this.markerSet.clear(addr);
    }

    public boolean intersects(Address start, Address end) {
        return this.markerSet.intersects(start, end);
    }

    public static void defineBookmarkTypes(Program program) {
        BookmarkManager mgr = program.getBookmarkManager();
        mgr.defineType("Note", NOTE_ICON, NOTE_COLOR, 0);
        mgr.defineType("Info", INFO_ICON, INFO_COLOR, 4);
        mgr.defineType("Warning", WARNING_ICON, WARNING_COLOR, 500);
        mgr.defineType("Error", ERROR_ICON, ERROR_COLOR, 1000);
        mgr.defineType("Analysis", ANALYSIS_ICON, ANALYSIS_COLOR, 6);
    }
}

