/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesPanel;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesProvider;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class LocationReferencesProviderContext
extends DefaultActionContext {
    private LocationReferencesProvider locationProvider;
    private List<LocationReference> selectedReferences;

    public LocationReferencesProviderContext(LocationReferencesProvider provider) {
        super((ComponentProvider)provider, (Component)provider.getTable());
        this.locationProvider = provider;
    }

    public List<LocationReference> getSelectedReferences() {
        if (this.selectedReferences == null) {
            LocationReferencesPanel panel = this.locationProvider.getPanel();
            this.selectedReferences = panel.getSelectedReferences();
        }
        return this.selectedReferences;
    }

    public List<LocationReference> getDeletableReferences() {
        ArrayList<LocationReference> results = new ArrayList<LocationReference>();
        List<LocationReference> refs = this.getSelectedReferences();
        for (LocationReference lr : refs) {
            if (!lr.isDeletable()) continue;
            results.add(lr);
        }
        return results;
    }
}

