/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayProvider
implements ByteProvider {
    private byte[] srcBytes;
    private String name;
    private FSRL fsrl;

    public ByteArrayProvider(byte[] bytes) {
        this(bytes, null);
    }

    public ByteArrayProvider(byte[] bytes, FSRL fsrl) {
        this.srcBytes = bytes;
        this.fsrl = fsrl;
    }

    public ByteArrayProvider(String name, byte[] bytes) {
        this.name = name;
        this.srcBytes = bytes;
    }

    @Override
    public void close() {
    }

    public void hardClose() {
        this.srcBytes = new byte[0];
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return this.fsrl != null ? this.fsrl.getName() : this.name;
    }

    @Override
    public String getAbsolutePath() {
        return this.fsrl != null ? this.fsrl.getPath() : "";
    }

    @Override
    public InputStream getInputStream(long index) throws IOException {
        this.assertValidIndex(index, true);
        return new ByteArrayInputStream(this.srcBytes, (int)index, this.srcBytes.length - (int)index);
    }

    @Override
    public long length() {
        return this.srcBytes.length;
    }

    @Override
    public boolean isValidIndex(long index) {
        return index >= 0L && index < this.length();
    }

    private void assertValidIndex(long index, boolean inclusiveMax) throws IOException {
        if (index < 0L || index > (long)this.srcBytes.length || !inclusiveMax && index == (long)this.srcBytes.length) {
            throw new IOException("Invalid position, index: " + index + ", max is: " + this.srcBytes.length);
        }
    }

    @Override
    public byte readByte(long index) throws IOException {
        this.assertValidIndex(index, false);
        return this.srcBytes[(int)index];
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        this.assertValidIndex(index, true);
        if (index + length > (long)this.srcBytes.length) {
            throw new IOException("Attempt to read beyond end of byte data");
        }
        byte[] destBytes = new byte[(int)length];
        System.arraycopy(this.srcBytes, (int)index, destBytes, 0, (int)length);
        return destBytes;
    }
}

