/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.codesignature;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.codesignature.CodeSignatureGenericBlob;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CodeSignatureCodeDirectory
extends CodeSignatureGenericBlob {
    private int version;
    private int flags;
    private int hashOffset;
    private int identOffset;
    private int nSpecialSlots;
    private int nCodeSlots;
    private int codeLimit;
    private int hashSize;
    private int hashType;
    private int platform;
    private int pageSize;
    private int spare2;
    private int scatterOffset;
    private int teamOffset;
    private int spare3;
    private long codeLimit64;
    private long execSegBase;
    private long execSegLimit;
    private long execSegFlags;
    private int runtime;
    private int preEncryptOffset;
    private int linkageHashType;
    private int linkageHashApplicationType;
    private int linkageApplicationSubType;
    private int linkageOffset;
    private int linkageSize;

    public CodeSignatureCodeDirectory(BinaryReader reader) throws IOException {
        super(reader);
        this.version = reader.readNextInt();
        this.flags = reader.readNextInt();
        this.hashOffset = reader.readNextInt();
        this.identOffset = reader.readNextInt();
        this.nSpecialSlots = reader.readNextInt();
        this.nCodeSlots = reader.readNextInt();
        this.codeLimit = reader.readNextInt();
        this.hashSize = reader.readNextUnsignedByte();
        this.hashType = reader.readNextUnsignedByte();
        this.platform = reader.readNextUnsignedByte();
        this.pageSize = reader.readNextUnsignedByte();
        this.spare2 = reader.readNextInt();
        if (this.version >= 131328) {
            this.scatterOffset = reader.readNextInt();
        }
        if (this.version >= 131584) {
            this.teamOffset = reader.readNextInt();
        }
        if (this.version >= 131840) {
            this.spare3 = reader.readNextInt();
            this.codeLimit64 = reader.readNextLong();
        }
        if (this.version >= 132096) {
            this.execSegBase = reader.readNextLong();
            this.execSegLimit = reader.readNextLong();
            this.execSegFlags = reader.readNextLong();
        }
        if (this.version >= 132352) {
            this.runtime = reader.readNextInt();
            this.preEncryptOffset = reader.readNextInt();
        }
        if (this.version >= 132608) {
            this.linkageHashType = reader.readNextUnsignedByte();
            this.linkageHashApplicationType = reader.readNextUnsignedByte();
            this.linkageApplicationSubType = reader.readNextUnsignedShort();
            this.linkageOffset = reader.readNextInt();
            this.linkageSize = reader.readNextInt();
        }
    }

    @Override
    public void markup(Program program, Address addr, MachHeader header, TaskMonitor monitor, MessageLog log) throws CancelledException {
        try {
            if (this.identOffset != 0) {
                Address identAddr = addr.add((long)this.identOffset);
                DataUtilities.createData((Program)program, (Address)identAddr, (DataType)STRING, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                program.getListing().setComment(identAddr, CommentType.PRE, "CS_CodeDirectory identifer");
            }
            if (this.teamOffset != 0) {
                Address teamAddr = addr.add((long)this.teamOffset);
                DataUtilities.createData((Program)program, (Address)teamAddr, (DataType)STRING, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                program.getListing().setComment(teamAddr, CommentType.PRE, "CS_CodeDirectory team identifier");
            }
            if (this.hashOffset != 0 && this.hashSize != 0) {
                Address hashAddr = addr.add((long)this.hashOffset);
                ArrayDataType hashArrayDt = new ArrayDataType(BYTE, this.hashSize, 1);
                ArrayDataType hasheArrayArrayDt = new ArrayDataType((DataType)hashArrayDt, this.nCodeSlots, 1);
                DataUtilities.createData((Program)program, (Address)hashAddr, (DataType)hasheArrayArrayDt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                program.getListing().setComment(hashAddr, CommentType.PRE, "CS_CodeDirectory hashes");
            }
        }
        catch (Exception e) {
            log.appendMsg(CodeSignatureCodeDirectory.class.getSimpleName(), "Failed to markup CS_CodeDirectory");
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("CS_CodeDirectory", 0);
        struct.add(DWORD, "magic", "magic number (CSMAGIC_CODEDIRECTORY)");
        struct.add(DWORD, "length", "total length of CodeDirectory blob");
        struct.add(DWORD, "version", "compatibility version");
        struct.add(DWORD, "flags", "setup and mode flags");
        struct.add(DWORD, "hashOffset", "offset of hash slot element at index zero");
        struct.add(DWORD, "identOffset", "offset of identifier string");
        struct.add(DWORD, "nSpecialSlots", "number of special hash slots");
        struct.add(DWORD, "nCodeSlots", "number of ordinary (code) hash slots");
        struct.add(DWORD, "codeLimit", "limit to main image signature range");
        struct.add(BYTE, "hashSize", "size of each hash in bytes");
        struct.add(BYTE, "hashType", "type of hash (cdHashType* constants)");
        struct.add(BYTE, "platform", "platform identifier; zero if not platform binary");
        struct.add(BYTE, "pageSize", "log2(page size in bytes); 0 => infinite");
        struct.add(DWORD, "spare2", "unused (must be zero)");
        if (this.version >= 131328) {
            struct.add(DWORD, "scatterOffset", "offset of optional scatter vector");
        }
        if (this.version >= 131584) {
            struct.add(DWORD, "teamOffset", "offset of optional team identifier");
        }
        if (this.version >= 131840) {
            struct.add(DWORD, "spare3", "unused (must be zero)");
            struct.add(QWORD, "codeLimit64", "limit to main image signature range, 64 bits");
        }
        if (this.version >= 132096) {
            struct.add(QWORD, "execSegBase", "offset of executable segment");
            struct.add(QWORD, "execSegLimit", "limit of executable segment");
            struct.add(QWORD, "execSegFlags", "executable segment flags");
        }
        if (this.version >= 132352) {
            struct.add(DWORD, "runtime", "");
            struct.add(DWORD, "preEncryptOffset", "");
        }
        if (this.version >= 132608) {
            struct.add(BYTE, "linkageHashType", "");
            struct.add(BYTE, "linkageHashApplicationType", "");
            struct.add(WORD, "linkageApplicationSubType", "");
            struct.add(DWORD, "linkageOffset", "");
            struct.add(DWORD, "linkageSize", "");
        }
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

