/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheLocalSymbolsEntry
implements StructConverter {
    private long dylibOffset;
    private int nlistStartIndex;
    private int nlistCount;
    private boolean use64bitOffsets;

    public DyldCacheLocalSymbolsEntry(BinaryReader reader, boolean use64bitOffsets) throws IOException {
        this.use64bitOffsets = use64bitOffsets;
        this.dylibOffset = use64bitOffsets ? reader.readNextLong() : (long)reader.readNextInt();
        this.nlistStartIndex = reader.readNextInt();
        this.nlistCount = reader.readNextInt();
    }

    public long getDylibOffset() {
        return this.dylibOffset;
    }

    public int getNListStartIndex() {
        return this.nlistStartIndex;
    }

    public int getNListCount() {
        return this.nlistCount;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_local_symbols_entry", 0);
        struct.add(this.use64bitOffsets ? QWORD : DWORD, "dylibOffset", "");
        struct.add(DWORD, "nlistStartIndex", "");
        struct.add(DWORD, "nlistCount", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

