/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import ghidra.app.util.bin.format.pe.debug.DebugSymbolSelector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OMFGlobal {
    private short symHash;
    private short addrHash;
    private int cbSymbol;
    private int cbSymHash;
    private int cbAddrHash;
    private ArrayList<DebugSymbol> symbols = new ArrayList();

    OMFGlobal(BinaryReader reader, int ptr) throws IOException {
        this.symHash = reader.readShort(ptr);
        this.addrHash = reader.readShort(ptr += 2);
        this.cbSymbol = reader.readInt(ptr += 2);
        this.cbSymHash = reader.readInt(ptr += 4);
        this.cbAddrHash = reader.readInt(ptr += 4);
        ptr += 4;
        int bytesLeft = this.cbSymbol;
        while (bytesLeft > 0) {
            DebugSymbol sym = DebugSymbolSelector.selectSymbol(reader, ptr);
            ptr += 4;
            bytesLeft -= 4;
            if (sym == null) continue;
            this.symbols.add(sym);
            int recLen = Short.toUnsignedInt(sym.getLength());
            bytesLeft -= recLen;
            ptr += recLen - 2;
        }
    }

    public short getAddrHash() {
        return this.addrHash;
    }

    public int getCbAddrHash() {
        return this.cbAddrHash;
    }

    public int getCbSymbol() {
        return this.cbSymbol;
    }

    public int getCbSymHash() {
        return this.cbSymHash;
    }

    public short getSymHash() {
        return this.symHash;
    }

    public List<DebugSymbol> getSymbols() {
        return this.symbols;
    }
}

