/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.opinion.Loader;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.framework.data.FolderLinkContentHandler;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.program.database.ProgramLinkContentHandler;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.TaskMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;

public class Loaded<T extends DomainObject>
implements AutoCloseable {
    protected final T domainObject;
    protected final String name;
    protected FSRL fsrl;
    protected Project project;
    protected String projectRootPath;
    protected boolean mirrorFsLayout;
    protected Object loadedConsumer;
    protected DomainFile domainFile;

    public Loaded(T domainObject, String name, FSRL fsrl, Project project, String projectRootPath, boolean mirrorFsLayout, Object consumer) {
        this.domainObject = domainObject;
        this.name = name;
        this.fsrl = fsrl;
        this.project = project;
        this.mirrorFsLayout = mirrorFsLayout;
        this.loadedConsumer = consumer;
        this.setProjectFolderPath(projectRootPath);
    }

    public Loaded(T domainObject, Loader.ImporterSettings settings) {
        this(domainObject, settings.importName(), settings.provider().getFSRL(), settings.project(), settings.projectRootPath(), settings.mirrorFsLayout(), settings.consumer());
    }

    public T getDomainObject(Object consumer) {
        this.domainObject.addConsumer(consumer);
        return this.domainObject;
    }

    @Deprecated(since="12.0", forRemoval=true)
    public T getDomainObject() {
        return this.domainObject;
    }

    public Class<? extends DomainObject> getDomainObjectType() {
        return this.domainObject.getClass();
    }

    public void apply(Consumer<T> operation) {
        operation.accept(this.domainObject);
    }

    public boolean check(Predicate<T> predicate) {
        return predicate.test(this.domainObject);
    }

    public String getName() {
        return this.name;
    }

    public Project getProject() {
        return this.project;
    }

    public String getProjectFolderPath() {
        return this.projectRootPath;
    }

    public void setProjectFolderPath(String projectRootPath) {
        if (projectRootPath == null || ((String)projectRootPath).isBlank()) {
            projectRootPath = "/";
        } else if (!((String)projectRootPath).endsWith("/")) {
            projectRootPath = (String)projectRootPath + "/";
        }
        this.projectRootPath = this.mirrorFsLayout ? FSUtilities.mirroredProjectPath((String)projectRootPath) : projectRootPath;
    }

    public DomainFile save(TaskMonitor monitor) throws CancelledException, ClosedException, IOException, InvalidNameException {
        if (this.project == null) {
            throw new IOException("Cannot save to null project");
        }
        if (this.domainObject.isClosed()) {
            throw new ClosedException("Cannot saved closed DomainObject: " + this.domainObject.getName());
        }
        try {
            if (this.getSavedDomainFile() != null) {
                throw new IOException("Already saved to " + String.valueOf(this.domainFile));
            }
        }
        catch (FileNotFoundException e) {
            this.domainFile = null;
        }
        if (this.mirrorFsLayout && this.fsrl != null) {
            this.domainFile = this.mirror(monitor);
            return this.domainFile;
        }
        int uniqueNameIndex = 0;
        Object uniqueName = FilenameUtils.getName((String)this.name);
        DomainFolder programFolder = ProjectDataUtils.createDomainFolderPath((DomainFolder)this.project.getProjectData().getRootFolder(), (String)FSUtilities.appendPath(this.projectRootPath, FilenameUtils.getFullPath((String)this.name)));
        while (!monitor.isCancelled()) {
            try {
                this.domainFile = programFolder.createFile((String)uniqueName, this.domainObject, monitor);
                return this.domainFile;
            }
            catch (DuplicateFileException e) {
                uniqueName = this.name + "." + uniqueNameIndex;
                ++uniqueNameIndex;
            }
        }
        throw new CancelledException();
    }

    public DomainFile getSavedDomainFile() throws FileNotFoundException {
        if (this.domainFile != null && !this.domainFile.exists()) {
            throw new FileNotFoundException("Saved DomainFile no longer exists: " + String.valueOf(this.domainFile));
        }
        return this.domainFile;
    }

    @Deprecated(since="12.0", forRemoval=true)
    public void release(Object consumer) {
        if (!this.domainObject.isClosed() && this.domainObject.isUsedBy(consumer)) {
            this.domainObject.release(consumer);
        }
    }

    @Override
    public void close() {
        if (this.loadedConsumer != null && !this.domainObject.isClosed() && this.domainObject.isUsedBy(this.loadedConsumer)) {
            this.domainObject.release(this.loadedConsumer);
        }
    }

    public String toString() {
        return this.getProjectFolderPath() + this.getName();
    }

    /*
     * Loose catch block
     */
    private DomainFile mirror(TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        DomainFolder mirrorRootProjectFolder = ProjectDataUtils.createDomainFolderPath((DomainFolder)this.project.getProjectData().getRootFolder(), (String)this.projectRootPath);
        String currentPath = null;
        HashSet<String> processedPaths = new HashSet<String>();
        String[] pathElements = FSUtilities.splitPath(this.fsrl.getPath());
        try (RefdFile ref = FileSystemService.getInstance().getRefdFile(this.fsrl, monitor);){
            for (int i = 0; i < pathElements.length; ++i) {
                Object symlink;
                String pathElement = pathElements[i];
                if (i == 0) {
                    if (!pathElement.isEmpty()) {
                        throw new IOException("FSRL '%s' is not absolute!".formatted(this.fsrl));
                    }
                    currentPath = "/";
                    continue;
                }
                if (processedPaths.contains(currentPath = FSUtilities.appendPath(currentPath, pathElement))) continue;
                GFileSystem fs = ref.fsRef.getFilesystem();
                GFile currentFile = fs.lookup(currentPath);
                String currentParentDirPath = currentFile.getParentFile().getPath();
                DomainFolder parentProjectFolder = ProjectDataUtils.getDomainFolder((DomainFolder)mirrorRootProjectFolder, (String)FSUtilities.mirroredProjectPath(currentParentDirPath));
                FileAttributes fattrs = fs.getFileAttributes(currentFile, monitor);
                String symlinkDest = fattrs.get(FileAttributeType.SYMLINK_DEST_ATTR, String.class, null);
                if (symlinkDest != null) {
                    MirroredLink mirroredLink = this.mirrorLinkInProject(currentFile, symlinkDest, parentProjectFolder, monitor);
                    symlink = mirroredLink.relative() ? FSUtilities.appendPath(currentParentDirPath, mirroredLink.symlink()) : mirroredLink.symlink();
                    symlink = Path.of(symlink, new String[0]).normalize().toString();
                    String[] oldElements = pathElements;
                    String[] newElements = FSUtilities.splitPath(symlink);
                    pathElements = Arrays.copyOf(newElements, newElements.length + oldElements.length - i - 1);
                    System.arraycopy(oldElements, i + 1, pathElements, newElements.length, pathElements.length - newElements.length);
                    i = -1;
                    continue;
                }
                if (currentFile.isDirectory()) {
                    ProjectDataUtils.createDomainFolderPath((DomainFolder)mirrorRootProjectFolder, (String)FSUtilities.mirroredProjectPath(currentPath));
                    processedPaths.add(currentPath);
                    continue;
                }
                try {
                    Program program;
                    symlink = this.domainObject;
                    if (symlink instanceof Program) {
                        program = (Program)symlink;
                        program.withTransaction("Updating Program Info", () -> {
                            program.setExecutablePath(FSUtilities.appendPath(parentProjectFolder.getPathname(), currentFile.getName()));
                            FSRL.writeToProgramInfo(program, currentFile.getFSRL());
                        });
                    }
                    program = parentProjectFolder.createFile(currentFile.getName(), this.domainObject, monitor);
                    return program;
                }
                catch (DuplicateFileException e) {
                    DomainFile domainFile;
                    block16: {
                        DomainFile f = parentProjectFolder.getFile(currentFile.getName());
                        Msg.warn((Object)this, (Object)("Skipping save of existing file: " + String.valueOf(f)));
                        domainFile = f;
                        if (ref == null) break block16;
                        ref.close();
                    }
                    return domainFile;
                }
            }
            throw new IOException("Path did not point to a file!");
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private MirroredLink mirrorLinkInProject(GFile file, String linkDest, DomainFolder folder, TaskMonitor monitor) throws IOException {
        boolean relative = FilenameUtils.getPrefixLength((String)linkDest) == 0;
        String projectLinkTarget = FSUtilities.mirroredProjectPath(relative ? FSUtilities.appendPath(this.projectRootPath, FilenameUtils.getFullPath((String)file.getPath()), linkDest) : FSUtilities.appendPath(this.projectRootPath, linkDest));
        DomainFile df = folder.getFile(file.getName());
        if (df == null) {
            df = folder.createLinkFile(this.project.getProjectData(), projectLinkTarget, relative, file.getName(), (LinkHandler)(file.isDirectory() ? FolderLinkContentHandler.INSTANCE : ProgramLinkContentHandler.INSTANCE));
        }
        return new MirroredLink(df, projectLinkTarget, linkDest, relative);
    }

    private record MirroredLink(DomainFile linkFile, String projectLinkTarget, String symlink, boolean relative) {
    }
}

