/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;

class MemorySection {
    protected final MemoryLoadable key;
    protected final boolean isInitialized;
    protected final long fileOffset;
    protected final long length;
    protected final boolean isFragmentationOK;
    protected final AddressRange physicalAddrRange;
    protected final String sectionName;
    protected final boolean isReadable;
    protected final boolean isWritable;
    protected final boolean isExecute;
    protected final String comment;

    MemorySection(MemoryLoadable key, boolean isInitialized, long fileOffset, long length, AddressRange physicalAddrRange, String sectionName, boolean isReadable, boolean isWritable, boolean isExecute, String comment, boolean isFragmentationOK) {
        AddressSpace space = physicalAddrRange.getAddressSpace();
        if (!space.isMemorySpace()) {
            throw new IllegalArgumentException("memory-based address required");
        }
        this.key = key;
        this.isInitialized = isInitialized;
        this.fileOffset = fileOffset;
        this.length = length;
        this.physicalAddrRange = physicalAddrRange;
        this.sectionName = sectionName;
        this.isReadable = isReadable;
        this.isWritable = isWritable;
        this.isExecute = isExecute;
        this.comment = comment;
        this.isFragmentationOK = isFragmentationOK;
    }

    public MemoryLoadable getKey() {
        return this.key;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public long getNumberOfBytes() {
        return this.length;
    }

    public AddressRange getPhysicalAddressRange() {
        return this.physicalAddrRange;
    }

    public Address getMinPhysicalAddress() {
        return this.physicalAddrRange.getMinAddress();
    }

    public Address getMaxPhysicalAddress() {
        return this.physicalAddrRange.getMaxAddress();
    }

    public AddressSpace getPhysicalAddressSpace() {
        return this.physicalAddrRange.getMinAddress().getAddressSpace();
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public boolean isLoaded() {
        return this.physicalAddrRange.getAddressSpace() != AddressSpace.OTHER_SPACE;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public boolean isExecute() {
        return this.isExecute;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return this.isInitialized ? String.format("%s (%d, %d @ %s)", this.sectionName, this.fileOffset, this.length, this.physicalAddrRange) : String.format("%s (uninitialized @ %s)", this.sectionName, this.physicalAddrRange);
    }
}

