/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.handler;

import ghidra.features.base.quickfix.QuickFix;
import ghidra.features.base.replace.SearchAndReplaceHandler;
import ghidra.features.base.replace.SearchAndReplaceQuery;
import ghidra.features.base.replace.SearchType;
import ghidra.features.base.replace.items.RenameProgramTreeGroupQuickFix;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProgramTreeSearchAndReplaceHandler
extends SearchAndReplaceHandler {
    public ProgramTreeSearchAndReplaceHandler() {
        this.addType(new SearchType(this, "Program Trees", "Search and replace program tree module and fragment names"));
    }

    @Override
    public void findAll(Program program, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        Listing listing = program.getListing();
        String[] treeNames = listing.getTreeNames();
        monitor.initialize((long)treeNames.length, "Search Program Trees");
        for (String treeName : treeNames) {
            monitor.increment();
            this.findAll(program, treeName, query, accumulator, monitor);
        }
    }

    private void findAll(Program program, String treeName, SearchAndReplaceQuery query, Accumulator<QuickFix> accumulator, TaskMonitor monitor) throws CancelledException {
        Set<Group> set = this.gatherProgramTreeGroups(program, treeName, monitor);
        Pattern pattern = query.getSearchPattern();
        for (Group group : set) {
            String name = group.getName();
            Matcher matcher = pattern.matcher(name);
            if (!matcher.find()) continue;
            String newName = matcher.replaceAll(query.getReplacementText());
            RenameProgramTreeGroupQuickFix item = new RenameProgramTreeGroupQuickFix(program, group, newName);
            accumulator.add((Object)item);
        }
    }

    private Set<Group> gatherProgramTreeGroups(Program program, String treeName, TaskMonitor monitor) throws CancelledException {
        monitor.checkCancelled();
        Listing listing = program.getListing();
        ProgramModule rootModule = listing.getRootModule(treeName);
        HashSet<Group> set = new HashSet<Group>();
        this.addProgramTreeGroupsRecursively(set, (Group)rootModule, monitor);
        set.remove(rootModule);
        return set;
    }

    private void addProgramTreeGroupsRecursively(Set<Group> set, Group group, TaskMonitor monitor) {
        set.add(group);
        if (group instanceof ProgramModule) {
            Group[] children;
            ProgramModule module = (ProgramModule)group;
            for (Group child : children = module.getChildren()) {
                this.addProgramTreeGroupsRecursively(set, child, monitor);
            }
        }
    }
}

