/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.ActionContext;
import docking.action.ActionContextProvider;
import docking.theme.gui.ColorValueEditor;
import docking.theme.gui.GThemeValuesCache;
import docking.theme.gui.ThemeColorTableModel;
import docking.theme.gui.ThemeTable;
import docking.theme.gui.ThemeTableContext;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.GTable;
import generic.theme.ColorValue;
import generic.theme.ThemeManager;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;

public class ThemeColorTable
extends JPanel
implements ActionContextProvider,
ThemeTable {
    private ThemeColorTableModel colorTableModel;
    private ColorValueEditor colorEditor = new ColorValueEditor(this::colorValueChanged);
    private GTable table;
    private GFilterTable<ColorValue> filterTable;
    private ThemeManager themeManager;

    public ThemeColorTable(ThemeManager themeManager, GThemeValuesCache valuesProvider) {
        super(new BorderLayout());
        this.themeManager = themeManager;
        this.colorTableModel = this.createModel(valuesProvider);
        this.filterTable = new GFilterTable<ColorValue>(this.colorTableModel);
        this.table = this.filterTable.getTable();
        this.table.setSelectionMode(1);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ColorValue colorValue = ThemeColorTable.this.filterTable.getSelectedRowObject();
                    if (colorValue != null) {
                        ThemeColorTable.this.colorEditor.editValue(colorValue);
                    }
                    e.consume();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ColorValue value = ThemeColorTable.this.filterTable.getItemAt(e.getPoint());
                    int col = ThemeColorTable.this.filterTable.getColumn(e.getPoint());
                    TableColumn column = ThemeColorTable.this.table.getColumnModel().getColumn(col);
                    Object identifier = column.getIdentifier();
                    if ("Current Color".equals(identifier) || "Id".equals(identifier)) {
                        ThemeColorTable.this.colorEditor.editValue(value);
                    }
                }
            }
        });
        this.add(this.filterTable, "Center");
    }

    ThemeColorTableModel createModel(GThemeValuesCache valuesProvider) {
        return new ThemeColorTableModel(valuesProvider);
    }

    @Override
    public void setShowSystemValues(boolean show) {
        this.colorTableModel.setShowSystemValues(show);
        this.reloadAll();
    }

    @Override
    public boolean isShowingSystemValues() {
        return this.colorTableModel.isShowingSystemValues();
    }

    void colorValueChanged(PropertyChangeEvent event) {
        Swing.runLater(() -> {
            ColorValue newValue = (ColorValue)event.getNewValue();
            this.themeManager.setColor(newValue);
        });
    }

    public void reloadCurrent() {
        this.colorTableModel.reloadCurrent();
    }

    public void reloadAll() {
        this.colorTableModel.reloadAll();
    }

    @Override
    public ActionContext getActionContext(MouseEvent e) {
        if (e != null && e.getSource() == this.table) {
            ColorValue currentValue = this.filterTable.getSelectedRowObject();
            if (currentValue == null) {
                return null;
            }
            String id = currentValue.getId();
            ColorValue themeValue = this.colorTableModel.getThemeValue(id);
            return new ThemeTableContext(currentValue, themeValue, this);
        }
        return null;
    }
}

