/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import ghidra.util.UserSearchUtils;
import java.util.List;
import java.util.regex.Pattern;
import javax.help.UnsupportedOperationException;
import javax.swing.ListCellRenderer;

public interface DropDownTextFieldDataModel<T> {
    public List<T> getMatchingData(String var1);

    default public List<T> getMatchingData(String searchText, SearchMode searchMode) {
        if (searchMode != SearchMode.UNKNOWN) {
            throw new UnsupportedOperationException("You must override this method to use search modes");
        }
        return this.getMatchingData(searchText);
    }

    default public List<SearchMode> getSupportedSearchModes() {
        return List.of(SearchMode.UNKNOWN);
    }

    public int getIndexOfFirstMatchingEntry(List<T> var1, String var2);

    public ListCellRenderer<T> getListRenderer();

    public String getDescription(T var1);

    public String getDisplayText(T var1);

    public static enum SearchMode {
        CONTAINS("()", "Contains"),
        STARTS_WITH("^", "Starts With"),
        WILDCARD("*?", "Wildcard"),
        UNKNOWN("", "");

        private String hint;
        private String displayName;

        private SearchMode(String hint, String displayName) {
            this.hint = hint;
            this.displayName = displayName;
        }

        public String getHint() {
            return this.hint;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Pattern createPattern(String input) {
            switch (this.ordinal()) {
                case 0: {
                    return UserSearchUtils.createContainsPattern((String)input, (boolean)false, (int)2);
                }
                case 1: {
                    return UserSearchUtils.createStartsWithPattern((String)input, (boolean)false, (int)2);
                }
                case 2: {
                    return UserSearchUtils.createContainsPattern((String)input, (boolean)true, (int)2);
                }
            }
            throw new IllegalStateException("Cannot create pattern for mode: " + String.valueOf((Object)this));
        }
    }
}

