/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.spinner;

import docking.widgets.textfield.IntegerTextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IntegerSpinner {
    private final JSpinner spinner;
    private final IntegerTextField integerTextField;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public IntegerSpinner(SpinnerNumberModel spinnerModel) {
        this(spinnerModel, 10);
    }

    public IntegerSpinner(final SpinnerNumberModel spinnerModel, int columns) {
        this.spinner = new JSpinner(spinnerModel);
        this.integerTextField = new IntegerTextField(columns, ((Number)spinnerModel.getValue()).longValue());
        this.integerTextField.getComponent().setName("integer.spinner.editor");
        Number maximum = (Number)((Object)spinnerModel.getMaximum());
        this.integerTextField.setMaxValue(maximum == null ? null : BigInteger.valueOf(maximum.longValue()));
        this.spinner.setEditor(this.integerTextField.getComponent());
        spinnerModel.addChangeListener(e -> {
            Number newVal = (Number)spinnerModel.getValue();
            this.integerTextField.setValue(newVal.longValue());
        });
        this.integerTextField.getComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object newVal = null;
                switch (e.getKeyCode()) {
                    case 38: {
                        newVal = spinnerModel.getNextValue();
                        break;
                    }
                    case 40: {
                        newVal = spinnerModel.getPreviousValue();
                        break;
                    }
                }
                if (newVal != null) {
                    e.consume();
                    IntegerSpinner.this.spinner.setValue(newVal);
                }
            }
        });
        this.spinner.addMouseWheelListener(e -> {
            SpinnerNumberModel model = (SpinnerNumberModel)this.spinner.getModel();
            try {
                if (e.getWheelRotation() > 0) {
                    Object previousValue = model.getPreviousValue();
                    if (previousValue != null) {
                        this.spinner.setValue(previousValue);
                    }
                } else {
                    Object nextValue = model.getNextValue();
                    if (nextValue != null) {
                        this.spinner.setValue(nextValue);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        this.integerTextField.addChangeListener(e -> {
            BigInteger value = this.integerTextField.getValue();
            if (value == null) {
                return;
            }
            spinnerModel.setValue(value.longValue());
        });
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    public IntegerTextField getTextField() {
        return this.integerTextField;
    }

    public void setValue(Number value) {
        this.spinner.setValue(value);
        this.integerTextField.setValue(value.longValue());
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

