/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import generic.util.FlattenedIterator;
import ghidra.lifecycle.Unfinished;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.EmptyAddressIterator;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceIteratorAdapter;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.symbol.DBTraceReference;
import ghidra.trace.database.symbol.DBTraceReferenceManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.listing.TraceCodeOperations;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceReferenceOperations;
import ghidra.util.IntersectionAddressSetView;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.help.UnsupportedOperationException;

public abstract class AbstractDBTraceProgramViewReferenceManager
implements ReferenceManager {
    protected final DBTraceProgramView program;
    protected TraceReferenceOperations refs;
    protected TraceCodeOperations code;
    protected final DBTraceReferenceManager refsManager;

    public AbstractDBTraceProgramViewReferenceManager(DBTraceProgramView program) {
        this.program = program;
        this.refs = this.getReferenceOperations(false);
        this.code = this.getCodeOperations(false);
        this.refsManager = program.trace.getReferenceManager();
    }

    protected abstract TraceReferenceOperations getReferenceOperations(boolean var1);

    protected abstract TraceCodeOperations getCodeOperations(boolean var1);

    private TraceReferenceOperations refs(boolean createIfAbsent) {
        if (this.refs == null) {
            this.refs = this.getReferenceOperations(createIfAbsent);
        }
        return this.refs;
    }

    private TraceCodeOperations code(boolean createIfAbsent) {
        if (this.code == null) {
            this.code = this.getCodeOperations(createIfAbsent);
        }
        return this.code;
    }

    protected Lifespan chooseLifespan(Address fromAddr) {
        TraceCodeUnit unit = this.code(false) == null ? null : this.code.codeUnits().getAt(this.program.snap, fromAddr);
        return unit == null ? Lifespan.nowOn(this.program.snap) : unit.getLifespan();
    }

    public Reference addReference(Reference reference) {
        return this.refs(true).addReference(this.chooseLifespan(reference.getFromAddress()), reference);
    }

    public Reference addStackReference(Address fromAddr, int opIndex, int stackOffset, RefType type, SourceType source) {
        return this.refs(true).addStackReference(this.chooseLifespan(fromAddr), fromAddr, stackOffset, type, source, opIndex);
    }

    public Reference addRegisterReference(Address fromAddr, int opIndex, Register register, RefType type, SourceType source) {
        return this.refs(true).addRegisterReference(this.chooseLifespan(fromAddr), fromAddr, register, type, source, opIndex);
    }

    public Reference addMemoryReference(Address fromAddr, Address toAddr, RefType type, SourceType source, int opIndex) {
        return this.refs(true).addMemoryReference(this.chooseLifespan(fromAddr), fromAddr, toAddr, type, source, opIndex);
    }

    public Reference addOffsetMemReference(Address fromAddr, Address toAddr, boolean toAddrIsBase, long offset, RefType type, SourceType source, int opIndex) {
        return this.refs(true).addOffsetReference(this.chooseLifespan(fromAddr), fromAddr, toAddr, toAddrIsBase, offset, type, source, opIndex);
    }

    public Reference addShiftedMemReference(Address fromAddr, Address toAddr, int shiftValue, RefType type, SourceType source, int opIndex) {
        return this.refs(true).addShiftedReference(this.chooseLifespan(fromAddr), fromAddr, toAddr, shiftValue, type, source, opIndex);
    }

    public Reference addExternalReference(Address fromAddr, String libraryName, String extLabel, Address extAddr, SourceType source, int opIndex, RefType type) throws InvalidInputException, DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public Reference addExternalReference(Address fromAddr, Namespace extNamespace, String extLabel, Address extAddr, SourceType source, int opIndex, RefType type) throws InvalidInputException, DuplicateNameException {
        throw new UnsupportedOperationException();
    }

    public Reference addExternalReference(Address fromAddr, int opIndex, ExternalLocation location, SourceType source, RefType type) throws InvalidInputException {
        throw new UnsupportedOperationException();
    }

    public void removeAllReferencesFrom(Address beginAddr, Address endAddr) {
        if (this.refs(false) == null) {
            return;
        }
        this.refs.clearReferencesFrom(Lifespan.at(this.program.snap), (AddressRange)new AddressRangeImpl(beginAddr, endAddr));
    }

    public void removeAllReferencesFrom(Address fromAddr) {
        if (this.refs(false) == null) {
            return;
        }
        this.refs.clearReferencesFrom(Lifespan.at(this.program.snap), (AddressRange)new AddressRangeImpl(fromAddr, fromAddr));
    }

    public void removeAllReferencesTo(Address toAddr) {
        if (this.refs(false) == null) {
            return;
        }
        this.refs.clearReferencesTo(Lifespan.at(this.program.snap), (AddressRange)new AddressRangeImpl(toAddr, toAddr));
    }

    public Reference[] getReferencesTo(Variable var) {
        return (Reference[])Unfinished.TODO();
    }

    public Variable getReferencedVariable(Reference reference) {
        return (Variable)Unfinished.TODO();
    }

    public void setPrimary(Reference ref, boolean isPrimary) {
        DBTraceReference dbRef = this.refsManager.assertIsMine(ref);
        dbRef.setPrimary(isPrimary);
    }

    protected boolean any(boolean noSpace, Predicate<Long> predicate) {
        if (this.refs(false) == null) {
            return noSpace;
        }
        for (long s : this.program.viewport.getOrderedSnaps()) {
            if (!predicate.test(s)) continue;
            return true;
        }
        return false;
    }

    protected Collection<Reference> collect(Function<Long, Collection<? extends Reference>> refFunc) {
        if (this.refs(false) == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<Reference> result = new LinkedHashSet<Reference>();
        for (long s : this.program.viewport.getOrderedSnaps()) {
            Collection<? extends Reference> from = refFunc.apply(s);
            if (from == null) continue;
            result.addAll(from);
        }
        return result;
    }

    public boolean hasFlowReferencesFrom(Address addr) {
        return this.any(false, s -> !this.refs.getFlowReferencesFrom((long)s, addr).isEmpty());
    }

    public Reference[] getFlowReferencesFrom(Address addr) {
        Collection<Reference> result = this.collect(s -> this.refs.getFlowReferencesFrom((long)s, addr));
        return result.toArray(new Reference[result.size()]);
    }

    public ReferenceIterator getExternalReferences() {
        return new ReferenceIteratorAdapter(Collections.emptyIterator());
    }

    public ReferenceIterator getReferencesTo(Address addr) {
        Collection<Reference> result = this.collect(s -> this.refs.getReferencesTo((long)s, addr));
        return new ReferenceIteratorAdapter(result.iterator());
    }

    protected Comparator<Reference> getReferenceFromComparator(boolean forward) {
        return forward ? (r1, r2) -> r1.getFromAddress().compareTo((Object)r2.getFromAddress()) : (r1, r2) -> -r1.getFromAddress().compareTo((Object)r2.getFromAddress());
    }

    protected Iterator<Reference> getReferenceIteratorForSnap(long snap, Address startAddr) {
        AddressIterator addresses = this.refs.getReferenceSources(Lifespan.at(snap)).getAddresses(startAddr, true);
        return FlattenedIterator.start((Iterator)addresses, a -> this.refs.getReferencesFrom(snap, (Address)a).iterator());
    }

    public ReferenceIterator getReferenceIterator(Address startAddr) {
        if (this.refs(false) == null) {
            return new ReferenceIteratorAdapter(Collections.emptyIterator());
        }
        return new ReferenceIteratorAdapter(this.program.viewport.mergedIterator(s -> this.getReferenceIteratorForSnap((long)s, startAddr), this.getReferenceFromComparator(true)));
    }

    public Reference getReference(Address fromAddr, Address toAddr, int opIndex) {
        if (this.refs(false) == null) {
            return null;
        }
        return this.program.viewport.getTop(s -> this.refs.getReference((long)s, fromAddr, toAddr, opIndex));
    }

    public Reference[] getReferencesFrom(Address addr) {
        Collection<Reference> result = this.collect(s -> this.refs.getReferencesFrom((long)s, addr));
        return result.toArray(new Reference[result.size()]);
    }

    public Reference[] getReferencesFrom(Address fromAddr, int opIndex) {
        Collection<Reference> result = this.collect(s -> this.refs.getReferencesFrom((long)s, fromAddr, opIndex));
        return result.toArray(new Reference[result.size()]);
    }

    public boolean hasReferencesFrom(Address fromAddr, int opIndex) {
        return this.any(false, s -> !this.refs.getReferencesFrom((long)s, fromAddr, opIndex).isEmpty());
    }

    public boolean hasReferencesFrom(Address fromAddr) {
        return this.any(false, s -> !this.refs.getReferencesFrom((long)s, fromAddr).isEmpty());
    }

    public Reference getPrimaryReferenceFrom(Address addr, int opIndex) {
        if (this.refs(false) == null) {
            return null;
        }
        return this.program.viewport.getTop(s -> this.refs.getPrimaryReferenceFrom((long)s, addr, opIndex));
    }

    public AddressIterator getReferenceSourceIterator(Address startAddr, boolean forward) {
        if (this.refs(false) == null) {
            return new EmptyAddressIterator();
        }
        return this.program.viewport.unionedAddresses(s -> this.refs.getReferenceSources(Lifespan.at(s))).getAddresses(startAddr, forward);
    }

    public AddressIterator getReferenceSourceIterator(AddressSetView addrSet, boolean forward) {
        if (this.refs(false) == null) {
            return new EmptyAddressIterator();
        }
        return new IntersectionAddressSetView(addrSet, this.program.viewport.unionedAddresses(s -> this.refs.getReferenceSources(Lifespan.at(s)))).getAddresses(forward);
    }

    public AddressIterator getReferenceDestinationIterator(Address startAddr, boolean forward) {
        if (this.refs(false) == null) {
            return new EmptyAddressIterator();
        }
        return this.program.viewport.unionedAddresses(s -> this.refs.getReferenceDestinations(Lifespan.at(s))).getAddresses(startAddr, forward);
    }

    public AddressIterator getReferenceDestinationIterator(AddressSetView addrSet, boolean forward) {
        if (this.refs(false) == null) {
            return new EmptyAddressIterator();
        }
        return new IntersectionAddressSetView(addrSet, this.program.viewport.unionedAddresses(s -> this.refs.getReferenceDestinations(Lifespan.at(s)))).getAddresses(forward);
    }

    public int getReferenceCountTo(Address toAddr) {
        if (this.refs(false) == null) {
            return 0;
        }
        if (!this.program.viewport.isForked()) {
            return this.refs.getReferenceCountTo(this.program.snap, toAddr);
        }
        return this.collect(s -> this.refs.getReferencesTo((long)s, toAddr)).size();
    }

    public int getReferenceCountFrom(Address fromAddr) {
        if (this.refs(false) == null) {
            return 0;
        }
        if (!this.program.viewport.isForked()) {
            return this.refs.getReferenceCountFrom(this.program.snap, fromAddr);
        }
        return this.collect(s -> this.refs.getReferencesFrom((long)s, fromAddr)).size();
    }

    public int getReferenceDestinationCount() {
        if (this.refs(false) == null) {
            return 0;
        }
        return (int)this.program.viewport.unionedAddresses(s -> this.refs.getReferenceDestinations(Lifespan.at(s))).getNumAddresses();
    }

    public int getReferenceSourceCount() {
        if (this.refs(false) == null) {
            return 0;
        }
        return (int)this.program.viewport.unionedAddresses(s -> this.refs.getReferenceSources(Lifespan.at(s))).getNumAddresses();
    }

    public boolean hasReferencesTo(Address toAddr) {
        return this.any(false, s -> !this.refs.getReferencesTo((long)s, toAddr).isEmpty());
    }

    public Reference updateRefType(Reference ref, RefType refType) {
        DBTraceReference dbRef = this.refsManager.assertIsMine(ref);
        dbRef.setReferenceType(refType);
        return ref;
    }

    public void setAssociation(Symbol s, Reference ref) {
        DBTraceReference dbRef = this.refsManager.assertIsMine(ref);
        dbRef.setAssociatedSymbol(s);
    }

    public void removeAssociation(Reference ref) {
        DBTraceReference dbRef = this.refsManager.assertIsMine(ref);
        dbRef.clearAssociatedSymbol();
    }

    public void delete(Reference ref) {
        DBTraceReference dbRef = this.refsManager.assertIsMine(ref);
        dbRef.delete();
    }

    public static byte getRefLevel(RefType rt) {
        if (rt == RefType.EXTERNAL_REF) {
            return 5;
        }
        if (rt.isCall()) {
            return 3;
        }
        if (rt.isData() || rt.isIndirect()) {
            return 1;
        }
        if (rt.isFlow()) {
            return 2;
        }
        return 0;
    }

    public byte getReferenceLevel(Address toAddr) {
        if (this.refs(false) == null) {
            return 0;
        }
        byte highest = 0;
        for (long s : this.program.viewport.getOrderedSnaps()) {
            for (TraceReference traceReference : this.refs.getReferencesTo(s, toAddr)) {
                highest = (byte)Math.max(highest, AbstractDBTraceProgramViewReferenceManager.getRefLevel(traceReference.getReferenceType()));
            }
        }
        return highest;
    }
}

