/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.elastic;

import generic.hash.SimpleCRC32;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.description.RowKey;
import ghidra.features.bsim.query.elastic.Base64Lite;

public class RowKeyElastic
extends RowKey {
    protected int valueA;
    protected int valueB;
    protected int valueC;

    private static int hexString2Int(String val, int start) {
        int res = 0;
        for (int i = 0; i < 8; ++i) {
            res <<= 4;
            char c = val.charAt(i + start);
            if (c <= '9') {
                res += c - 48;
                continue;
            }
            res += c - 97 + 10;
        }
        return res;
    }

    public RowKeyElastic(long val) {
        this.valueA = 0;
        this.valueB = (int)(val >>> 32);
        this.valueC = (int)val;
    }

    public RowKeyElastic(int a, int b, int c) {
        this.valueA = a;
        this.valueB = b;
        this.valueC = c;
    }

    public RowKeyElastic(String md5) {
        this.valueA = RowKeyElastic.hexString2Int(md5, 8);
        this.valueB = RowKeyElastic.hexString2Int(md5, 16);
        this.valueC = RowKeyElastic.hexString2Int(md5, 24);
    }

    public RowKeyElastic() {
        this.valueA = 0;
        this.valueB = 0;
        this.valueC = 0;
    }

    @Override
    public long getLong() {
        long res = this.valueB;
        res = res << 32 | (long)this.valueC & 0xFFFFFFFFL;
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        RowKeyElastic o = (RowKeyElastic)obj;
        return this.valueA == o.valueA && this.valueB == o.valueB && this.valueC == o.valueC;
    }

    public int hashCode() {
        int res = this.valueA;
        res = res * 113 + this.valueB;
        res = res * 113 + this.valueC;
        return res;
    }

    @Override
    public int compareTo(RowKey obj) {
        RowKeyElastic o = (RowKeyElastic)obj;
        if (this.valueA != o.valueA) {
            long valA = (long)this.valueA & 0xFFFFFFFFL;
            long ovalA = (long)o.valueA & 0xFFFFFFFFL;
            return valA < ovalA ? -1 : 1;
        }
        if (this.valueB != o.valueB) {
            long valB = (long)this.valueB & 0xFFFFFFFFL;
            long ovalB = (long)o.valueB & 0xFFFFFFFFL;
            return valB < ovalB ? -1 : 1;
        }
        if (this.valueC != o.valueC) {
            long valC = (long)this.valueC & 0xFFFFFFFFL;
            long ovalC = (long)o.valueC & 0xFFFFFFFFL;
            return valC < ovalC ? -1 : 1;
        }
        return 0;
    }

    public String generateExeIdString() {
        StringBuilder buf = new StringBuilder();
        int curInt = this.valueA;
        int chunk = curInt >> 26 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 20 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 14 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 8 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 2 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = (curInt & 3) << 4;
        curInt = this.valueB;
        buf.append(Base64Lite.encode[chunk |= curInt >>> 28]);
        chunk = curInt >> 22 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 16 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 10 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 4 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = (curInt & 0xF) << 2;
        curInt = this.valueC;
        buf.append(Base64Lite.encode[chunk |= curInt >>> 30]);
        chunk = curInt >> 24 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 18 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 12 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt >> 6 & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        chunk = curInt & 0x3F;
        buf.append(Base64Lite.encode[chunk]);
        return buf.toString();
    }

    public void generateLibraryFunctionId(StringBuilder buffer, String funcName) {
        int hi = this.valueB;
        int lo = this.valueC;
        lo &= 0xFFFF0000;
        for (int i = 0; i < funcName.length(); ++i) {
            int tmp = lo >>> 24;
            lo = SimpleCRC32.hashOneByte((int)lo, (int)funcName.charAt(i));
            hi = SimpleCRC32.hashOneByte((int)hi, (int)tmp);
        }
        long res = hi;
        res <<= 32;
        res |= (long)lo & 0xFFFFFFFFL;
        int extra = this.valueC & 0xFFFF;
        buffer.append(Base64Lite.encode[extra >> 10 & 0x3F]);
        buffer.append(Base64Lite.encode[extra >> 4 & 0x3F]);
        buffer.append(Base64Lite.encode[extra & 0xF]);
        Base64Lite.encodeLongBase64Padded(buffer, res);
    }

    public void generateFunctionId(StringBuilder buffer, FunctionDescription func) {
        ExecutableRecord exeRec = func.getExecutableRecord();
        if (!exeRec.isLibrary()) {
            buffer.append(func.getId().getLong());
            return;
        }
        this.generateLibraryFunctionId(buffer, func.getFunctionName());
    }

    public static RowKeyElastic parseExeIdString(String id) {
        int valueA = Base64Lite.decode[id.charAt(0)];
        valueA <<= 6;
        valueA |= Base64Lite.decode[id.charAt(1)];
        valueA <<= 6;
        valueA |= Base64Lite.decode[id.charAt(2)];
        valueA <<= 6;
        valueA |= Base64Lite.decode[id.charAt(3)];
        valueA <<= 6;
        valueA |= Base64Lite.decode[id.charAt(4)];
        int valueB = Base64Lite.decode[id.charAt(5)];
        valueA = valueA << 2 | valueB >> 4;
        valueB <<= 6;
        valueB |= Base64Lite.decode[id.charAt(6)];
        valueB <<= 6;
        valueB |= Base64Lite.decode[id.charAt(7)];
        valueB <<= 6;
        valueB |= Base64Lite.decode[id.charAt(8)];
        valueB <<= 6;
        valueB |= Base64Lite.decode[id.charAt(9)];
        int valueC = Base64Lite.decode[id.charAt(10)];
        valueB = valueB << 4 | valueC >> 2;
        valueC <<= 6;
        valueC |= Base64Lite.decode[id.charAt(11)];
        valueC <<= 6;
        valueC |= Base64Lite.decode[id.charAt(12)];
        valueC <<= 6;
        valueC |= Base64Lite.decode[id.charAt(13)];
        valueC <<= 6;
        valueC |= Base64Lite.decode[id.charAt(14)];
        valueC <<= 6;
        return new RowKeyElastic(valueA, valueB, valueC |= Base64Lite.decode[id.charAt(15)]);
    }

    public static RowKeyElastic parseFunctionId(String val) {
        if (val.length() != 14) {
            return new RowKeyElastic(Long.parseLong(val));
        }
        int extra = Base64Lite.decode[val.charAt(0)];
        extra <<= 6;
        extra |= Base64Lite.decode[val.charAt(1)];
        extra <<= 6;
        long low = Base64Lite.decodeLongBase64(val.substring(3));
        return new RowKeyElastic(extra |= Base64Lite.decode[val.charAt(2)], (int)(low >>> 32), (int)low);
    }
}

