/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.datatypes.SwiftPrimitive;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;
import ghidra.program.model.data.DataUtilities;

public class SwiftGlobalNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        Demangled demangled = null;
        Demangled suffix = null;
        block4: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case GenericSpecialization: 
                case MergedFunction: 
                case ObjCAttribute: {
                    continue block4;
                }
                case Suffix: {
                    suffix = child.demangle(demangler);
                    continue block4;
                }
            }
            demangled = child.demangle(demangler);
        }
        if (demangled == null) {
            return this.getUnknown();
        }
        if (suffix != null && !(demangled instanceof SwiftPrimitive) && DataUtilities.isValidDataTypeName((String)suffix.getName())) {
            demangled.setName(demangled.getName() + suffix.getName());
        }
        return demangled;
    }
}

