/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.app.plugin.processors.generic.Handle;
import ghidra.app.plugin.processors.generic.Operand;
import ghidra.app.plugin.processors.generic.Position;
import ghidra.app.plugin.processors.generic.SledException;
import ghidra.program.model.address.Address;
import java.io.Serializable;
import java.util.HashMap;

public class ConstantTemplate
implements Serializable {
    public static final int REAL = 1;
    public static final int HANDLE = 2;
    public static final int JUMP_START = 3;
    public static final int JUMP_NEXT = 4;
    public static final int JUMP_CODESPACE = 5;
    private int hashCode;
    private int type;
    private Operand op;
    private long realValue;
    private int select1;
    private int select2;

    public ConstantTemplate(long val) {
        this.type = 1;
        this.realValue = val;
        this.hashCode = (int)val;
    }

    public ConstantTemplate(int t) {
        this.type = t;
        this.hashCode = t;
    }

    public ConstantTemplate(Operand o, int sel1, int sel2) {
        this.type = 2;
        this.op = o;
        this.select1 = sel1;
        this.select2 = sel2;
        this.hashCode = this.op.hashCode() + this.select1 + 10 * this.select2;
    }

    public ConstantTemplate(Operand o, int sel1) throws SledException {
        this(o, sel1, 0);
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new SledException("invalid ConstantTemplate type encountered in resolve");
            }
        }
    }

    public int type() {
        return this.type;
    }

    public int select1() {
        return this.select1;
    }

    public int select2() {
        return this.select2;
    }

    public long resolve(Position position, int off) throws Exception {
        switch (this.type) {
            case 1: {
                return this.realValue;
            }
            case 2: {
                return this.op.getHandle(position, off).getLong(this.select1, this.select2);
            }
            case 3: {
                return position.startAddr().getOffset();
            }
            case 4: {
                return position.nextAddr().getOffset();
            }
            case 5: {
                Address addr = position.buffer().getAddress();
                return addr.getAddressSpace().getSpaceID();
            }
        }
        return 0L;
    }

    public long resolve(HashMap<Object, Handle> handles, Position position, int off) throws Exception {
        if (this.type == 2) {
            return handles.get(this.op).getLong(this.select1, this.select2);
        }
        return this.resolve(position, off);
    }

    public Operand operand() {
        return this.op;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o.getClass() != ConstantTemplate.class) {
            return false;
        }
        ConstantTemplate ct = (ConstantTemplate)o;
        if (ct.hashCode() != this.hashCode) {
            return false;
        }
        if (ct.type() != this.type) {
            return false;
        }
        if (this.type == 2) {
            if (!ct.operand().equals(this.op)) {
                return false;
            }
            if (ct.select1() != this.select1) {
                return false;
            }
            if (ct.select2() != this.select2) {
                return false;
            }
        }
        return true;
    }
}

